/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.Value;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ListSubscriber;
import de.themoep.connectorplugin.lib.lettuce.core.output.OutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ValueValueListOutput<K, V>
extends CommandOutput<K, V, List<Value<V>>>
implements StreamingOutput<Value<V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Value<V>> subscriber;

    public ValueValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Value<V>>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext((Collection)this.output, Value.fromNullable(bytes == null ? null : (Object)this.codec.decodeValue(bytes)));
    }

    @Override
    public void set(long integer) {
        this.subscriber.onNext((Collection)this.output, Value.fromNullable(integer));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Value<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Value<V>> getSubscriber() {
        return this.subscriber;
    }
}

