/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.protocol;

import de.themoep.connectorplugin.lib.lettuce.core.protocol.ChannelLogDescriptor;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import de.themoep.connectorplugin.lib.netty.buffer.ByteBuf;
import de.themoep.connectorplugin.lib.netty.channel.Channel;
import de.themoep.connectorplugin.lib.netty.channel.ChannelHandlerContext;
import de.themoep.connectorplugin.lib.netty.handler.codec.EncoderException;
import de.themoep.connectorplugin.lib.netty.handler.codec.MessageToByteEncoder;
import de.themoep.connectorplugin.lib.netty.util.internal.PlatformDependent;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.util.Collection;

public class CommandEncoder
extends MessageToByteEncoder<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CommandEncoder.class);
    private final boolean traceEnabled = logger.isTraceEnabled();
    private final boolean debugEnabled = logger.isDebugEnabled();

    public CommandEncoder() {
        this(PlatformDependent.directBufferPreferred());
    }

    public CommandEncoder(boolean preferDirect) {
        super(preferDirect);
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, Object msg, boolean preferDirect) throws Exception {
        if (msg instanceof Collection) {
            if (preferDirect) {
                return ctx.alloc().ioBuffer(((Collection)msg).size() * 16);
            }
            return ctx.alloc().heapBuffer(((Collection)msg).size() * 16);
        }
        if (preferDirect) {
            return ctx.alloc().ioBuffer();
        }
        return ctx.alloc().heapBuffer();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        out.touch("CommandEncoder.encode(\u2026)");
        if (msg instanceof RedisCommand) {
            RedisCommand command = (RedisCommand)msg;
            this.encode(ctx, out, command);
        }
        if (msg instanceof Collection) {
            Collection commands = (Collection)msg;
            for (RedisCommand command : commands) {
                this.encode(ctx, out, command);
            }
        }
    }

    private void encode(ChannelHandlerContext ctx, ByteBuf out, RedisCommand<?, ?, ?> command) {
        try {
            out.markWriterIndex();
            command.encode(out);
        }
        catch (RuntimeException e) {
            out.resetWriterIndex();
            command.completeExceptionally(new EncoderException("Cannot encode command. Please close the connection as the connection state may be out of sync.", e));
        }
        if (this.debugEnabled) {
            logger.debug("{} writing command {}", (Object)this.logPrefix(ctx.channel()), (Object)command);
            if (this.traceEnabled) {
                logger.trace("{} Sent: {}", (Object)this.logPrefix(ctx.channel()), (Object)out.toString(Charset.defaultCharset()).trim());
            }
        }
    }

    private String logPrefix(Channel channel) {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append('[').append(ChannelLogDescriptor.logDescriptor(channel)).append(']');
        return buffer.toString();
    }
}

