/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.protocol;

import de.themoep.connectorplugin.lib.lettuce.core.ClientOptions;
import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.TimeoutOptions;
import de.themoep.connectorplugin.lib.lettuce.core.internal.ExceptionFactory;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CompleteableCommand;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ConnectionFacade;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import de.themoep.connectorplugin.lib.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CommandExpiryWriter
implements RedisChannelWriter {
    private final RedisChannelWriter writer;
    private final TimeoutOptions.TimeoutSource source;
    private final TimeUnit timeUnit;
    private final ScheduledExecutorService executorService;
    private final boolean applyConnectionTimeout;
    private volatile long timeout = -1L;

    public CommandExpiryWriter(RedisChannelWriter writer, ClientOptions clientOptions, ClientResources clientResources) {
        LettuceAssert.notNull((Object)writer, "RedisChannelWriter must not be null");
        LettuceAssert.isTrue(CommandExpiryWriter.isSupported(clientOptions), "Command timeout not enabled");
        LettuceAssert.notNull((Object)clientResources, "ClientResources must not be null");
        TimeoutOptions timeoutOptions = clientOptions.getTimeoutOptions();
        this.writer = writer;
        this.source = timeoutOptions.getSource();
        this.applyConnectionTimeout = timeoutOptions.isApplyConnectionTimeout();
        this.timeUnit = this.source.getTimeUnit();
        this.executorService = clientResources.eventExecutorGroup();
    }

    public static boolean isSupported(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        return CommandExpiryWriter.isSupported(clientOptions.getTimeoutOptions());
    }

    private static boolean isSupported(TimeoutOptions timeoutOptions) {
        LettuceAssert.notNull((Object)timeoutOptions, "TimeoutOptions must not be null");
        return timeoutOptions.isTimeoutCommands();
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connectionFacade) {
        this.writer.setConnectionFacade(connectionFacade);
    }

    @Override
    public ClientResources getClientResources() {
        return this.writer.getClientResources();
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.writer.setAutoFlushCommands(autoFlush);
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        this.potentiallyExpire(command, this.getExecutorService());
        return this.writer.write(command);
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> redisCommands) {
        ScheduledExecutorService executorService = this.getExecutorService();
        for (RedisCommand<K, V, ?> command : redisCommands) {
            this.potentiallyExpire(command, executorService);
        }
        return this.writer.write(redisCommands);
    }

    @Override
    public void flushCommands() {
        this.writer.flushCommands();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.writer.closeAsync();
    }

    @Override
    public void reset() {
        this.writer.reset();
    }

    public void setTimeout(Duration timeout) {
        this.timeout = this.timeUnit.convert(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    private ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    private void potentiallyExpire(RedisCommand<?, ?, ?> command, ScheduledExecutorService executors) {
        long timeout;
        long l = timeout = this.applyConnectionTimeout ? this.timeout : this.source.getTimeout(command);
        if (timeout <= 0L) {
            return;
        }
        ScheduledFuture<?> schedule = executors.schedule(() -> {
            if (!command.isDone()) {
                command.completeExceptionally(ExceptionFactory.createTimeoutException(Duration.ofNanos(this.timeUnit.toNanos(timeout))));
            }
        }, timeout, this.timeUnit);
        if (command instanceof CompleteableCommand) {
            ((CompleteableCommand)((Object)command)).onComplete((o, o2) -> {
                if (!schedule.isDone()) {
                    schedule.cancel(false);
                }
            });
        }
    }
}

