/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.protocol;

import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.internal.ExceptionFactory;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ConnectionInitializer;
import de.themoep.connectorplugin.lib.lettuce.core.resource.ClientResources;
import de.themoep.connectorplugin.lib.netty.channel.ChannelHandlerContext;
import de.themoep.connectorplugin.lib.netty.channel.ChannelInboundHandlerAdapter;
import de.themoep.connectorplugin.lib.netty.util.Timeout;
import de.themoep.connectorplugin.lib.netty.util.concurrent.Future;
import de.themoep.connectorplugin.lib.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public class RedisHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final ConnectionInitializer connectionInitializer;
    private final ClientResources clientResources;
    private final Duration initializeTimeout;
    private final CompletableFuture<Void> handshakeFuture = new CompletableFuture();

    public RedisHandshakeHandler(ConnectionInitializer connectionInitializer, ClientResources clientResources, Duration initializeTimeout) {
        this.connectionInitializer = connectionInitializer;
        this.clientResources = clientResources;
        this.initializeTimeout = initializeTimeout;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        Runnable timeoutGuard = () -> {
            if (this.handshakeFuture.isDone()) {
                return;
            }
            this.fail(ctx, ExceptionFactory.createTimeoutException("Connection initialization timed out", this.initializeTimeout));
        };
        Timeout timeoutHandle = this.clientResources.timer().newTimeout(t -> {
            if (this.clientResources.eventExecutorGroup().isShuttingDown()) {
                timeoutGuard.run();
                return;
            }
            this.clientResources.eventExecutorGroup().submit(timeoutGuard);
        }, this.initializeTimeout.toNanos(), TimeUnit.NANOSECONDS);
        this.handshakeFuture.thenAccept(ignore -> timeoutHandle.cancel());
        super.channelRegistered(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakeFuture.isDone()) {
            this.fail(ctx, new RedisConnectionException("Connection closed prematurely"));
        }
        super.channelInactive(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        CompletionStage<Void> future = this.connectionInitializer.initialize(ctx.channel());
        future.whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                this.fail(ctx, (Throwable)throwable);
            } else {
                ctx.fireChannelActive();
                this.succeed();
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.handshakeFuture.isDone()) {
            this.fail(ctx, cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    protected void succeed() {
        this.handshakeFuture.complete(null);
    }

    protected void fail(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> this.handshakeFuture.completeExceptionally(cause)));
    }

    public CompletionStage<Void> channelInitialized() {
        return this.handshakeFuture;
    }
}

