/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.pubsub;

import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.RedisCommandExecutionException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisFuture;
import de.themoep.connectorplugin.lib.lettuce.core.StatefulRedisConnectionImpl;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.PubSubEndpoint;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubListener;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.api.reactive.RedisPubSubReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatefulRedisPubSubConnectionImpl<K, V>
extends StatefulRedisConnectionImpl<K, V>
implements StatefulRedisPubSubConnection<K, V> {
    private final PubSubEndpoint<K, V> endpoint;

    public StatefulRedisPubSubConnectionImpl(PubSubEndpoint<K, V> endpoint, RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(writer, endpoint, codec, timeout);
        this.endpoint = endpoint;
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.addListener(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.removeListener(listener);
    }

    @Override
    public RedisPubSubAsyncCommands<K, V> async() {
        return (RedisPubSubAsyncCommands)((Object)this.async);
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisPubSubCommands<K, V> sync() {
        return (RedisPubSubCommands)this.sync;
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)this.syncHandler(this.async(), RedisPubSubCommands.class);
    }

    @Override
    public RedisPubSubReactiveCommands<K, V> reactive() {
        return (RedisPubSubReactiveCommands)((Object)this.reactive);
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisPubSubReactiveCommandsImpl(this, this.codec);
    }

    protected List<RedisFuture<Void>> resubscribe() {
        ArrayList<RedisFuture<Void>> result = new ArrayList<RedisFuture<Void>>();
        if (this.endpoint.hasChannelSubscriptions()) {
            result.add(this.async().subscribe(this.toArray(this.endpoint.getChannels())));
        }
        if (this.endpoint.hasPatternSubscriptions()) {
            result.add(this.async().psubscribe(this.toArray(this.endpoint.getPatterns())));
        }
        return result;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }

    @Override
    public void activated() {
        super.activated();
        for (RedisFuture<Void> command : this.resubscribe()) {
            command.exceptionally(throwable -> {
                if (throwable instanceof RedisCommandExecutionException) {
                    InternalLoggerFactory.getInstance(this.getClass()).warn("Re-subscribe failed: " + command.getError());
                }
                return null;
            });
        }
    }
}

