/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.resource;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceClassUtils;
import de.themoep.connectorplugin.lib.lettuce.core.resource.Transports;
import de.themoep.connectorplugin.lib.netty.channel.socket.SocketChannel;
import de.themoep.connectorplugin.lib.netty.resolver.AddressResolverGroup;
import de.themoep.connectorplugin.lib.netty.resolver.DefaultAddressResolverGroup;
import de.themoep.connectorplugin.lib.netty.resolver.dns.DefaultDnsCache;
import de.themoep.connectorplugin.lib.netty.resolver.dns.DefaultDnsCnameCache;
import de.themoep.connectorplugin.lib.netty.resolver.dns.DnsAddressResolverGroup;
import de.themoep.connectorplugin.lib.netty.resolver.dns.DnsCache;
import de.themoep.connectorplugin.lib.netty.resolver.dns.DnsCnameCache;
import de.themoep.connectorplugin.lib.netty.resolver.dns.DnsNameResolverBuilder;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;

class AddressResolverGroupProvider {
    private static final InternalLogger logger;
    private static final AddressResolverGroup<?> ADDRESS_RESOLVER_GROUP;

    AddressResolverGroupProvider() {
    }

    static AddressResolverGroup<?> addressResolverGroup() {
        return ADDRESS_RESOLVER_GROUP;
    }

    static {
        DefaultAddressResolverGroup group;
        logger = InternalLoggerFactory.getInstance(AddressResolverGroupProvider.class);
        boolean dnsResolverAvailable = LettuceClassUtils.isPresent("de.themoep.connectorplugin.lib.netty.resolver.dns.DnsAddressResolverGroup");
        if (dnsResolverAvailable) {
            logger.debug("Starting with netty's non-blocking DNS resolver library");
            group = DefaultDnsAddressResolverGroupWrapper.INSTANCE;
        } else {
            logger.debug("Starting without optional netty's non-blocking DNS resolver library");
            group = DefaultAddressResolverGroup.INSTANCE;
        }
        ADDRESS_RESOLVER_GROUP = group;
    }

    private static class DefaultDnsAddressResolverGroupWrapper {
        static AddressResolverGroup<?> INSTANCE = new DnsAddressResolverGroup(new DnsNameResolverBuilder().channelType(Transports.datagramChannelClass()).socketChannelType(Transports.socketChannelClass().asSubclass(SocketChannel.class)).cnameCache((DnsCnameCache)new DefaultDnsCnameCache()).resolveCache((DnsCache)new DefaultDnsCache()));

        private DefaultDnsAddressResolverGroupWrapper() {
        }
    }
}

