/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.resource;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.resource.EventLoopResources;
import de.themoep.connectorplugin.lib.lettuce.core.resource.EventLoopResourcesWrapper;
import de.themoep.connectorplugin.lib.lettuce.core.resource.UnavailableResources;
import de.themoep.connectorplugin.lib.netty.channel.Channel;
import de.themoep.connectorplugin.lib.netty.channel.EventLoopGroup;
import de.themoep.connectorplugin.lib.netty.channel.kqueue.KQueue;
import de.themoep.connectorplugin.lib.netty.channel.kqueue.KQueueDatagramChannel;
import de.themoep.connectorplugin.lib.netty.channel.kqueue.KQueueDomainSocketChannel;
import de.themoep.connectorplugin.lib.netty.channel.kqueue.KQueueEventLoopGroup;
import de.themoep.connectorplugin.lib.netty.channel.kqueue.KQueueSocketChannel;
import de.themoep.connectorplugin.lib.netty.channel.socket.DatagramChannel;
import de.themoep.connectorplugin.lib.netty.channel.unix.DomainSocketAddress;
import de.themoep.connectorplugin.lib.netty.util.concurrent.EventExecutorGroup;
import de.themoep.connectorplugin.lib.netty.util.internal.SystemPropertyUtil;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class KqueueProvider {
    private static final InternalLogger logger;
    private static final String KQUEUE_ENABLED_KEY = "de.themoep.connectorplugin.lib.lettuce.core.kqueue";
    private static final boolean KQUEUE_ENABLED;
    private static final boolean KQUEUE_AVAILABLE;
    private static final EventLoopResources KQUEUE_RESOURCES;

    public static boolean isAvailable() {
        return KQUEUE_AVAILABLE && KQUEUE_ENABLED;
    }

    static void checkForKqueueLibrary() {
        LettuceAssert.assertState(KQUEUE_ENABLED, String.format("kqueue use is disabled via System properties (%s)", KQUEUE_ENABLED_KEY));
        LettuceAssert.assertState(KqueueProvider.isAvailable(), "netty-transport-native-kqueue is not available. Make sure netty-transport-native-kqueue library on the class path and supported by your operating system.");
    }

    public static EventLoopResources getResources() {
        return KQUEUE_RESOURCES;
    }

    static {
        boolean availability;
        logger = InternalLoggerFactory.getInstance(KqueueProvider.class);
        KQUEUE_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get(KQUEUE_ENABLED_KEY, "true"));
        try {
            Class.forName("de.themoep.connectorplugin.lib.netty.channel.kqueue.KQueue");
            availability = KQueue.isAvailable();
        }
        catch (ClassNotFoundException e) {
            availability = false;
        }
        KQUEUE_AVAILABLE = availability;
        if (KQUEUE_AVAILABLE) {
            logger.debug("Starting with kqueue library");
            KQUEUE_RESOURCES = new EventLoopResourcesWrapper(KqueueResources.INSTANCE, KqueueProvider::checkForKqueueLibrary);
        } else {
            logger.debug("Starting without optional kqueue library");
            KQUEUE_RESOURCES = new EventLoopResourcesWrapper(UnavailableResources.INSTANCE, KqueueProvider::checkForKqueueLibrary);
        }
    }

    static enum KqueueResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(this.eventLoopGroupClass());
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueEventLoopGroup.class;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            KqueueProvider.checkForKqueueLibrary();
            return new KQueueEventLoopGroup(nThreads, threadFactory);
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueSocketChannel.class;
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueDatagramChannel.class;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueDomainSocketChannel.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            KqueueProvider.checkForKqueueLibrary();
            return new DomainSocketAddress(socketPath);
        }
    }

    static enum UnavailableKqueueResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            KqueueProvider.checkForKqueueLibrary();
            return false;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }
    }
}

