/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.resource;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.resource.EpollProvider;
import de.themoep.connectorplugin.lib.lettuce.core.resource.EventLoopResources;
import de.themoep.connectorplugin.lib.lettuce.core.resource.IOUringProvider;
import de.themoep.connectorplugin.lib.lettuce.core.resource.KqueueProvider;
import de.themoep.connectorplugin.lib.netty.channel.Channel;
import de.themoep.connectorplugin.lib.netty.channel.EventLoopGroup;
import de.themoep.connectorplugin.lib.netty.channel.nio.NioEventLoopGroup;
import de.themoep.connectorplugin.lib.netty.channel.socket.DatagramChannel;
import de.themoep.connectorplugin.lib.netty.channel.socket.nio.NioDatagramChannel;
import de.themoep.connectorplugin.lib.netty.channel.socket.nio.NioSocketChannel;

public class Transports {
    public static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.eventLoopGroupClass();
        }
        return NioEventLoopGroup.class;
    }

    public static Class<? extends Channel> socketChannelClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.socketChannelClass();
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> datagramChannelClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.datagramChannelClass();
        }
        return NioDatagramChannel.class;
    }

    public static class NativeTransports {
        static EventLoopResources RESOURCES = KqueueProvider.isAvailable() ? KqueueProvider.getResources() : (IOUringProvider.isAvailable() ? IOUringProvider.getResources() : EpollProvider.getResources());

        static boolean isAvailable() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable() || IOUringProvider.isAvailable();
        }

        public static boolean isDomainSocketSupported() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable();
        }

        static Class<? extends Channel> socketChannelClass() {
            return RESOURCES.socketChannelClass();
        }

        static Class<? extends DatagramChannel> datagramChannelClass() {
            return RESOURCES.datagramChannelClass();
        }

        public static Class<? extends Channel> domainSocketChannelClass() {
            NativeTransports.assertDomainSocketAvailable();
            return RESOURCES.domainSocketChannelClass();
        }

        public static Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return RESOURCES.eventLoopGroupClass();
        }

        public static void assertDomainSocketAvailable() {
            LettuceAssert.assertState(NativeTransports.isDomainSocketSupported(), "A unix domain socket connection requires epoll or kqueue and neither is available");
        }
    }
}

