/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.sentinel;

import de.themoep.connectorplugin.lib.lettuce.core.ConnectionState;
import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelHandler;
import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.output.StatusOutput;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.AsyncCommand;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.Command;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandType;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.RedisSentinelAsyncCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.RedisSentinelReactiveCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.api.async.RedisSentinelAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.api.reactive.RedisSentinelReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.api.sync.RedisSentinelCommands;
import java.time.Duration;
import java.util.Collection;

public class StatefulRedisSentinelConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisSentinelConnection<K, V> {
    protected final RedisCodec<K, V> codec;
    protected final RedisSentinelCommands<K, V> sync;
    protected final RedisSentinelAsyncCommands<K, V> async;
    protected final RedisSentinelReactiveCommands<K, V> reactive;
    private final SentinelConnectionState connectionState = new SentinelConnectionState();

    public StatefulRedisSentinelConnectionImpl(RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(writer, timeout);
        this.codec = codec;
        this.async = new RedisSentinelAsyncCommandsImpl<K, V>(this, codec);
        this.sync = (RedisSentinelCommands)this.syncHandler(this.async, RedisSentinelCommands.class);
        this.reactive = new RedisSentinelReactiveCommandsImpl<K, V>(this, codec);
    }

    @Override
    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        return super.dispatch(command);
    }

    @Override
    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        return super.dispatch(commands);
    }

    @Override
    public RedisSentinelCommands<K, V> sync() {
        return this.sync;
    }

    @Override
    public RedisSentinelAsyncCommands<K, V> async() {
        return this.async;
    }

    @Override
    public RedisSentinelReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    @Deprecated
    public void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.connectionState.setClientName(clientName);
        this.dispatch(async);
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    static class SentinelConnectionState
    extends ConnectionState {
        SentinelConnectionState() {
        }

        @Override
        protected void setClientName(String clientName) {
            super.setClientName(clientName);
        }
    }
}

