/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.support;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.support.BasePoolConfig;

public abstract class BasePool {
    private final boolean testOnCreate;
    private final boolean testOnAcquire;
    private final boolean testOnRelease;

    protected BasePool(BasePoolConfig poolConfig) {
        LettuceAssert.notNull((Object)poolConfig, "PoolConfig must not be null");
        this.testOnCreate = poolConfig.isTestOnCreate();
        this.testOnAcquire = poolConfig.isTestOnAcquire();
        this.testOnRelease = poolConfig.isTestOnRelease();
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public boolean isTestOnAcquire() {
        return this.testOnAcquire;
    }

    public boolean isTestOnRelease() {
        return this.testOnRelease;
    }

    static <T extends Throwable> T unknownStackTrace(T cause, Class<?> clazz, String method) {
        cause.setStackTrace(new StackTraceElement[]{new StackTraceElement(clazz.getName(), method, null, -1)});
        return cause;
    }
}

