/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.support;

import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Futures;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.support.AsyncObjectFactory;
import de.themoep.connectorplugin.lib.lettuce.core.support.AsyncPool;
import de.themoep.connectorplugin.lib.lettuce.core.support.BasePool;
import de.themoep.connectorplugin.lib.lettuce.core.support.BoundedPoolConfig;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BoundedAsyncPool<T>
extends BasePool
implements AsyncPool<T> {
    private static final CompletableFuture<Void> COMPLETED = CompletableFuture.completedFuture(null);
    private static final IllegalStateException POOL_SHUTDOWN = BoundedAsyncPool.unknownStackTrace(new IllegalStateException("AsyncPool is closed"), BoundedAsyncPool.class, "acquire()");
    private static final NoSuchElementException POOL_EXHAUSTED = BoundedAsyncPool.unknownStackTrace(new NoSuchElementException("Pool exhausted"), BoundedAsyncPool.class, "acquire()");
    private static final IllegalStateException NOT_PART_OF_POOL = BoundedAsyncPool.unknownStackTrace(new IllegalStateException("Returned object not currently part of this pool"), BoundedAsyncPool.class, "release()");
    public static final CompletableFuture<Object> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private final int maxTotal;
    private final int maxIdle;
    private final int minIdle;
    private final AsyncObjectFactory<T> factory;
    private final Queue<T> cache;
    private final Queue<T> all;
    private final AtomicInteger objectCount = new AtomicInteger();
    private final AtomicInteger objectsInCreationCount = new AtomicInteger();
    private final AtomicInteger idleCount = new AtomicInteger();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile State state = State.ACTIVE;

    public BoundedAsyncPool(AsyncObjectFactory<T> factory, BoundedPoolConfig poolConfig) {
        this(factory, poolConfig, true);
    }

    BoundedAsyncPool(AsyncObjectFactory<T> factory, BoundedPoolConfig poolConfig, boolean createIdle) {
        super(poolConfig);
        LettuceAssert.notNull(factory, "AsyncObjectFactory must not be null");
        this.maxTotal = poolConfig.getMaxTotal();
        this.maxIdle = poolConfig.getMaxIdle();
        this.minIdle = poolConfig.getMinIdle();
        this.factory = factory;
        this.cache = new ConcurrentLinkedQueue<T>();
        this.all = new ConcurrentLinkedQueue<T>();
        if (createIdle) {
            this.createIdle();
        }
    }

    public static <T> CompletionStage<BoundedAsyncPool<T>> create(AsyncObjectFactory<T> factory, BoundedPoolConfig poolConfig) {
        BoundedAsyncPool pool = new BoundedAsyncPool(factory, poolConfig, false);
        CompletableFuture future = new CompletableFuture();
        pool.createIdle().whenComplete((v, throwable) -> {
            if (throwable == null) {
                future.complete(pool);
            } else {
                pool.closeAsync().whenComplete((v1, throwable1) -> future.completeExceptionally(new RedisConnectionException("Could not create pool", (Throwable)throwable)));
            }
        });
        return future;
    }

    CompletableFuture<Void> createIdle() {
        int potentialIdle = this.getMinIdle() - this.getIdle();
        if (potentialIdle <= 0 || !this.isPoolActive()) {
            return COMPLETED_FUTURE;
        }
        int totalLimit = this.getAvailableCapacity();
        int toCreate = Math.min(Math.max(0, totalLimit), potentialIdle);
        CompletableFuture[] futures = new CompletableFuture[toCreate];
        for (int i = 0; i < toCreate; ++i) {
            CompletableFuture future;
            if (this.getAvailableCapacity() <= 0) {
                futures[i] = COMPLETED_FUTURE;
                continue;
            }
            futures[i] = future = new CompletableFuture();
            this.makeObject0(future);
            future.thenAccept(it -> {
                if (this.isPoolActive()) {
                    this.idleCount.incrementAndGet();
                    this.cache.add(it);
                } else {
                    this.factory.destroy(it);
                }
            });
        }
        return CompletableFuture.allOf(futures);
    }

    private int getAvailableCapacity() {
        return this.getMaxTotal() - (this.getCreationInProgress() + this.getObjectCount());
    }

    @Override
    public CompletableFuture<T> acquire() {
        T object = this.cache.poll();
        CompletableFuture res = new CompletableFuture();
        this.acquire0(object, res);
        return res;
    }

    private void acquire0(T object, CompletableFuture<T> res) {
        if (object != null) {
            this.idleCount.decrementAndGet();
            if (this.isTestOnAcquire()) {
                this.factory.validate(object).whenComplete((state, throwable) -> {
                    if (!this.isPoolActive()) {
                        res.completeExceptionally(POOL_SHUTDOWN);
                        return;
                    }
                    if (state != null && state.booleanValue()) {
                        this.completeAcquire(res, object);
                        return;
                    }
                    this.destroy0(object).whenComplete((aVoid, th) -> this.makeObject0(res));
                });
                return;
            }
            if (this.isPoolActive()) {
                this.completeAcquire(res, object);
            } else {
                res.completeExceptionally(POOL_SHUTDOWN);
            }
            this.createIdle();
            return;
        }
        long objects = this.getObjectCount() + this.getCreationInProgress();
        if ((long)this.getMaxTotal() >= objects + 1L) {
            this.makeObject0(res);
            return;
        }
        res.completeExceptionally(POOL_EXHAUSTED);
    }

    private void makeObject0(CompletableFuture<T> res) {
        long total = this.getObjectCount();
        long creations = this.objectsInCreationCount.incrementAndGet();
        if ((long)this.getMaxTotal() < total + creations) {
            res.completeExceptionally(POOL_EXHAUSTED);
            this.objectsInCreationCount.decrementAndGet();
            return;
        }
        this.factory.create().whenComplete((o, t) -> {
            if (t != null) {
                this.objectsInCreationCount.decrementAndGet();
                res.completeExceptionally(new IllegalStateException("Cannot allocate object", (Throwable)t));
                return;
            }
            if (this.isTestOnCreate()) {
                this.factory.validate(o).whenComplete((state, throwable) -> {
                    try {
                        if (this.isPoolActive() && state != null && state.booleanValue()) {
                            this.objectCount.incrementAndGet();
                            this.all.add(o);
                            this.completeAcquire(res, o);
                            return;
                        }
                        if (!this.isPoolActive()) {
                            this.rejectPoolClosed(res, o);
                            return;
                        }
                        this.factory.destroy(o).whenComplete((v, th) -> res.completeExceptionally(new IllegalStateException("Cannot allocate object: Validation failed", (Throwable)throwable)));
                    }
                    catch (Exception e) {
                        this.factory.destroy(o).whenComplete((v, th) -> res.completeExceptionally(new IllegalStateException("Cannot allocate object: Validation failed", (Throwable)throwable)));
                    }
                    finally {
                        this.objectsInCreationCount.decrementAndGet();
                    }
                });
                return;
            }
            try {
                if (this.isPoolActive()) {
                    this.objectCount.incrementAndGet();
                    this.all.add(o);
                    this.completeAcquire(res, o);
                } else {
                    this.rejectPoolClosed(res, o);
                }
            }
            catch (Exception e) {
                this.objectCount.decrementAndGet();
                this.all.remove(o);
                this.factory.destroy(o).whenComplete((v, th) -> res.completeExceptionally(e));
            }
            finally {
                this.objectsInCreationCount.decrementAndGet();
            }
        });
    }

    private void completeAcquire(CompletableFuture<T> res, T o) {
        if (res.isCancelled()) {
            this.return0(o);
        } else {
            res.complete(o);
        }
    }

    private void rejectPoolClosed(CompletableFuture<T> res, T o) {
        this.factory.destroy(o);
        res.completeExceptionally(POOL_SHUTDOWN);
    }

    @Override
    public CompletableFuture<Void> release(T object) {
        if (!this.all.contains(object)) {
            return Futures.failed(NOT_PART_OF_POOL);
        }
        if (this.idleCount.get() >= this.getMaxIdle()) {
            return this.destroy0(object);
        }
        if (this.isTestOnRelease()) {
            CompletableFuture<Boolean> valid = this.factory.validate(object);
            CompletableFuture<Void> res = new CompletableFuture<Void>();
            valid.whenComplete((state1, throwable) -> {
                if (state1 != null && state1.booleanValue()) {
                    this.return0(object).whenComplete((x, y) -> res.complete(null));
                } else {
                    this.destroy0(object).whenComplete((x, y) -> res.complete(null));
                }
            });
            return res;
        }
        return this.return0(object);
    }

    private CompletableFuture<Void> return0(T object) {
        int idleCount = this.idleCount.incrementAndGet();
        if (idleCount > this.getMaxIdle()) {
            this.idleCount.decrementAndGet();
            return this.destroy0(object);
        }
        this.cache.add(object);
        return COMPLETED;
    }

    private CompletableFuture<Void> destroy0(T object) {
        this.objectCount.decrementAndGet();
        this.all.remove(object);
        return this.factory.destroy(object);
    }

    @Override
    public void clear() {
        this.clearAsync().join();
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        T cached;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(this.all.size());
        while ((cached = this.cache.poll()) != null) {
            this.idleCount.decrementAndGet();
            this.objectCount.decrementAndGet();
            this.all.remove(cached);
            futures.add(this.factory.destroy(cached));
        }
        return Futures.allOf(futures);
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (!this.isPoolActive()) {
            return this.closeFuture;
        }
        this.state = State.TERMINATING;
        CompletableFuture<Void> clear = this.clearAsync();
        this.state = State.TERMINATED;
        clear.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.closeFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.closeFuture.complete((Void)aVoid);
            }
        });
        return this.closeFuture;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        int maxIdleSave = this.getMaxIdle();
        if (this.minIdle > maxIdleSave) {
            return maxIdleSave;
        }
        return this.minIdle;
    }

    public int getIdle() {
        return this.idleCount.get();
    }

    public int getObjectCount() {
        return this.objectCount.get();
    }

    public int getCreationInProgress() {
        return this.objectsInCreationCount.get();
    }

    private boolean isPoolActive() {
        return this.state == State.ACTIVE;
    }

    static enum State {
        ACTIVE,
        TERMINATING,
        TERMINATED;

    }
}

