/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.netty.handler.address;

import de.themoep.connectorplugin.lib.netty.channel.ChannelHandler;
import de.themoep.connectorplugin.lib.netty.channel.ChannelHandlerContext;
import de.themoep.connectorplugin.lib.netty.channel.ChannelOutboundHandlerAdapter;
import de.themoep.connectorplugin.lib.netty.channel.ChannelPromise;
import de.themoep.connectorplugin.lib.netty.resolver.AddressResolver;
import de.themoep.connectorplugin.lib.netty.resolver.AddressResolverGroup;
import de.themoep.connectorplugin.lib.netty.util.concurrent.Future;
import de.themoep.connectorplugin.lib.netty.util.concurrent.FutureListener;
import de.themoep.connectorplugin.lib.netty.util.concurrent.GenericFutureListener;
import de.themoep.connectorplugin.lib.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

