/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.netty.handler.codec.serialization;

import de.themoep.connectorplugin.lib.netty.handler.codec.serialization.CachingClassResolver;
import de.themoep.connectorplugin.lib.netty.handler.codec.serialization.ClassLoaderClassResolver;
import de.themoep.connectorplugin.lib.netty.handler.codec.serialization.ClassResolver;
import de.themoep.connectorplugin.lib.netty.handler.codec.serialization.SoftReferenceMap;
import de.themoep.connectorplugin.lib.netty.handler.codec.serialization.WeakReferenceMap;
import de.themoep.connectorplugin.lib.netty.util.internal.PlatformDependent;
import java.util.HashMap;

public final class ClassResolvers {
    public static ClassResolver cacheDisabled(ClassLoader classLoader) {
        return new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader));
    }

    public static ClassResolver weakCachingResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new WeakReferenceMap(new HashMap()));
    }

    public static ClassResolver softCachingResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new SoftReferenceMap(new HashMap()));
    }

    public static ClassResolver weakCachingConcurrentResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new WeakReferenceMap(PlatformDependent.newConcurrentHashMap()));
    }

    public static ClassResolver softCachingConcurrentResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new SoftReferenceMap(PlatformDependent.newConcurrentHashMap()));
    }

    static ClassLoader defaultClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader contextClassLoader = PlatformDependent.getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return PlatformDependent.getClassLoader(ClassResolvers.class);
    }

    private ClassResolvers() {
    }
}

