/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.netty.handler.ipfilter;

import de.themoep.connectorplugin.lib.netty.channel.ChannelFuture;
import de.themoep.connectorplugin.lib.netty.channel.ChannelFutureListener;
import de.themoep.connectorplugin.lib.netty.channel.ChannelHandler;
import de.themoep.connectorplugin.lib.netty.channel.ChannelHandlerContext;
import de.themoep.connectorplugin.lib.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import de.themoep.connectorplugin.lib.netty.util.internal.ConcurrentSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

