/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.netty.handler.ssl;

import de.themoep.connectorplugin.lib.netty.buffer.ByteBufAllocator;
import de.themoep.connectorplugin.lib.netty.handler.ssl.ApplicationProtocolConfig;
import de.themoep.connectorplugin.lib.netty.handler.ssl.CipherSuiteFilter;
import de.themoep.connectorplugin.lib.netty.handler.ssl.ClientAuth;
import de.themoep.connectorplugin.lib.netty.handler.ssl.OpenSsl;
import de.themoep.connectorplugin.lib.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import de.themoep.connectorplugin.lib.netty.handler.ssl.OpenSslEngine;
import de.themoep.connectorplugin.lib.netty.handler.ssl.ReferenceCountedOpenSslContext;
import de.themoep.connectorplugin.lib.netty.handler.ssl.SslContextOption;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public abstract class OpenSslContext
extends ReferenceCountedOpenSslContext {
    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apnCfg, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, OpenSslContext.toNegotiator(apnCfg), mode, keyCertChain, clientAuth, protocols, startTls, enableOcsp, false, options);
    }

    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, apn, mode, keyCertChain, clientAuth, protocols, startTls, enableOcsp, false, options);
    }

    @Override
    final SSLEngine newEngine0(ByteBufAllocator alloc, String peerHost, int peerPort, boolean jdkCompatibilityMode) {
        return new OpenSslEngine(this, alloc, peerHost, peerPort, jdkCompatibilityMode);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        OpenSsl.releaseIfNeeded(this);
    }
}

