/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttConnectionOptions;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttMessage;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.UserProperty;
import java.util.ArrayList;

public class MqttConnectionOptionsBuilder {
    private MqttConnectionOptions mqttConnectionOptions = new MqttConnectionOptions();

    public MqttConnectionOptionsBuilder serverURI(String serverURI) {
        this.mqttConnectionOptions.setServerURIs(new String[]{serverURI});
        return this;
    }

    public MqttConnectionOptionsBuilder serverURIs(String[] serverURIs) {
        this.mqttConnectionOptions.setServerURIs(serverURIs);
        return this;
    }

    public MqttConnectionOptionsBuilder automaticReconnect(boolean enabled) {
        this.mqttConnectionOptions.setAutomaticReconnect(enabled);
        return this;
    }

    public MqttConnectionOptionsBuilder automaticReconnectDelay(int minimum, int maximum) {
        this.mqttConnectionOptions.setAutomaticReconnectDelay(minimum, maximum);
        return this;
    }

    public MqttConnectionOptionsBuilder keepAliveInterval(int keepAlive) {
        this.mqttConnectionOptions.setKeepAliveInterval(keepAlive);
        return this;
    }

    public MqttConnectionOptionsBuilder connectionTimeout(int connectionTimeout) {
        this.mqttConnectionOptions.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public MqttConnectionOptionsBuilder cleanStart(boolean cleanStart) {
        this.mqttConnectionOptions.setCleanStart(cleanStart);
        return this;
    }

    public MqttConnectionOptionsBuilder username(String username) {
        this.mqttConnectionOptions.setUserName(username);
        return this;
    }

    public MqttConnectionOptionsBuilder password(byte[] password) {
        this.mqttConnectionOptions.setPassword(password);
        return this;
    }

    public MqttConnectionOptionsBuilder will(String topic, MqttMessage message) {
        this.mqttConnectionOptions.setWill(topic, message);
        return this;
    }

    public MqttConnectionOptionsBuilder sessionExpiryInterval(Long sessionExpiryInterval) {
        this.mqttConnectionOptions.setSessionExpiryInterval(sessionExpiryInterval);
        return this;
    }

    public MqttConnectionOptionsBuilder maximumPacketSize(Long maximumPacketSize) {
        this.mqttConnectionOptions.setMaximumPacketSize(maximumPacketSize);
        return this;
    }

    public MqttConnectionOptionsBuilder topicAliasMaximum(Integer topicAliasMaximum) {
        this.mqttConnectionOptions.setTopicAliasMaximum(topicAliasMaximum);
        return this;
    }

    public MqttConnectionOptionsBuilder requestReponseInfo(Boolean requestResponseInfo) {
        this.mqttConnectionOptions.setRequestResponseInfo(requestResponseInfo);
        return this;
    }

    public MqttConnectionOptionsBuilder requestProblemInfo(Boolean requestProblemInfo) {
        this.mqttConnectionOptions.setRequestProblemInfo(requestProblemInfo);
        return this;
    }

    public MqttConnectionOptionsBuilder userProperties(ArrayList<UserProperty> properties) {
        this.mqttConnectionOptions.setUserProperties(properties);
        return this;
    }

    public MqttConnectionOptionsBuilder authMethod(String authMethod) {
        this.mqttConnectionOptions.setAuthMethod(authMethod);
        return this;
    }

    public MqttConnectionOptionsBuilder authData(byte[] authData) {
        this.mqttConnectionOptions.setAuthData(authData);
        return this;
    }

    public MqttConnectionOptions build() {
        return this.mqttConnectionOptions;
    }
}

