/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.internal;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.ClientComms;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.ClientState;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.CommsTokenStore;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.Logger;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.LoggerFactory;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.wire.MqttInputStream;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttAck;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttDisconnect;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private Logger log = LoggerFactory.getLogger("de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private String threadName;
    private Future<?> receiverFuture;
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(clientState, in, clientComms.getClient().getClientId());
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        this.log.fine(CommsReceiver.CLASS_NAME, "start", "855");
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.receiverFuture = executorService.submit(this);
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl21
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception v1) {}
lbl21:
            // 3 sources

        } while (!this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop() {
        var1_1 = this.lifecycle;
        synchronized (var1_1) {
            if (this.receiverFuture != null) {
                this.receiverFuture.cancel(true);
            }
            this.log.fine(CommsReceiver.CLASS_NAME, "stop", "850");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl19
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception v1) {}
lbl19:
            // 3 sources

        } while (this.isRunning());
        this.log.fine(CommsReceiver.CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        token = null;
        var2_2 = this.lifecycle;
        synchronized (var2_2) {
            this.current_state = State.RUNNING;
        }
        try {
            var3_3 = this.lifecycle;
            synchronized (var3_3) {
                my_target = this.target_state;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 19] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (true) ** GOTO lbl124
            }
            do {
                block62: {
                    block61: {
                        try {
                            this.log.fine(CommsReceiver.CLASS_NAME, "run", "852");
                            if (this.in.available() > 0) {
                                var3_3 = this.lifecycle;
                                synchronized (var3_3) {
                                    this.current_state = State.RECEIVING;
                                }
                            }
                            message = this.in.readMqttWireMessage();
                            var4_6 = this.lifecycle;
                            synchronized (var4_6) {
                                this.current_state = State.RUNNING;
                            }
                            if (message instanceof MqttAck) {
                                token = this.tokenStore.getToken(message);
                                if (token != null) {
                                    var4_6 = token;
                                    synchronized (var4_6) {
                                        this.clientState.notifyReceivedAck((MqttAck)message);
                                        break block61;
                                    }
                                }
                                this.log.fine(CommsReceiver.CLASS_NAME, "run", "857");
                                this.clientState.handleOrphanedAcks((MqttAck)message);
                                break block61;
                            }
                            if (message != null && message instanceof MqttDisconnect) {
                                this.clientComms.shutdownConnection(null, new MqttException(32204, (MqttDisconnect)message), (MqttDisconnect)message);
                            } else if (message != null) {
                                this.clientState.notifyReceivedMsg(message);
                            } else if (!this.clientComms.isConnected() && !this.clientComms.isConnecting()) {
                                throw new IOException("Connection is lost.");
                            }
                        }
                        catch (MqttException ex) {
                            this.log.fine(CommsReceiver.CLASS_NAME, "run", "856", null, ex);
                            var4_6 = this.lifecycle;
                            synchronized (var4_6) {
                                this.target_state = State.STOPPED;
                            }
                            this.clientComms.shutdownConnection(token, ex, null);
                            var6_7 = this.lifecycle;
                            synchronized (var6_7) {
                                this.current_state = State.RUNNING;
                                break block62;
                            }
                        }
                        catch (IOException ioe) {
                            try {
                                this.log.fine(CommsReceiver.CLASS_NAME, "run", "853");
                                if (this.target_state != State.STOPPED) {
                                    var4_6 = this.lifecycle;
                                    synchronized (var4_6) {
                                        this.target_state = State.STOPPED;
                                    }
                                    if (!this.clientComms.isDisconnecting()) {
                                        this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe), null);
                                    }
                                }
                                var6_7 = this.lifecycle;
                            }
                            catch (Throwable var5_8) {
                                var6_7 = this.lifecycle;
                                synchronized (var6_7) {
                                    this.current_state = State.RUNNING;
                                }
                                throw var5_8;
                            }
                            synchronized (var6_7) {
                                this.current_state = State.RUNNING;
                                break block62;
                            }
                        }
                    }
                    var6_7 = this.lifecycle;
                    synchronized (var6_7) {
                        this.current_state = State.RUNNING;
                    }
                }
                var3_3 = this.lifecycle;
                synchronized (var3_3) {
                    my_target = this.target_state;
                }
lbl124:
                // 2 sources

            } while (my_target == State.RUNNING && this.in != null);
        }
        catch (Throwable var7_9) {
            var8_10 = this.lifecycle;
            synchronized (var8_10) {
                this.current_state = State.STOPPED;
            }
            throw var7_9;
        }
        var8_11 = this.lifecycle;
        synchronized (var8_11) {
            this.current_state = State.STOPPED;
        }
        this.recThread = null;
        this.log.fine(CommsReceiver.CLASS_NAME, "run", "854");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = (this.current_state == State.RUNNING || this.current_state == State.RECEIVING) && this.target_state == State.RUNNING;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiving() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = this.current_state == State.RECEIVING;
        }
        return result;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        STARTING,
        RECEIVING;

    }
}

