/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.internal;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.IMqttToken;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttActionListener;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttAsyncClient;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttCallback;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttClientPersistence;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttConnectionOptions;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttToken;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.ClientComms;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.MqttConnectionState;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.MqttSessionState;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttPersistenceException;

public class ConnectActionListener
implements MqttActionListener {
    private MqttClientPersistence persistence;
    private MqttAsyncClient client;
    private ClientComms comms;
    private MqttConnectionOptions options;
    private MqttToken userToken;
    private Object userContext;
    private MqttActionListener userCallback;
    private MqttCallback mqttCallback;
    private MqttSessionState mqttSession;
    private MqttConnectionState mqttConnection;
    private boolean reconnect;

    public ConnectActionListener(MqttAsyncClient client, MqttClientPersistence persistence, ClientComms comms, MqttConnectionOptions options, MqttToken userToken, Object userContext, MqttActionListener userCallback, boolean reconnect, MqttSessionState mqttSession, MqttConnectionState mqttConnection) {
        this.persistence = persistence;
        this.client = client;
        this.comms = comms;
        this.options = options;
        this.userToken = userToken;
        this.userContext = userContext;
        this.userCallback = userCallback;
        this.reconnect = reconnect;
        this.mqttSession = mqttSession;
        this.mqttConnection = mqttConnection;
    }

    @Override
    public void onSuccess(IMqttToken token) {
        MqttToken myToken = (MqttToken)token;
        if (myToken.getResponseProperties() != null) {
            this.mqttConnection.setReceiveMaximum(myToken.getResponseProperties().getReceiveMaximum());
            this.mqttConnection.setMaximumQoS(myToken.getResponseProperties().getMaximumQoS());
            this.mqttConnection.setRetainAvailable(myToken.getResponseProperties().isRetainAvailable());
            this.mqttConnection.setOutgoingMaximumPacketSize(myToken.getResponseProperties().getMaximumPacketSize());
            this.mqttConnection.setIncomingMaximumPacketSize(this.options.getMaximumPacketSize());
            this.mqttConnection.setOutgoingTopicAliasMaximum(myToken.getResponseProperties().getTopicAliasMaximum());
            this.mqttConnection.setWildcardSubscriptionsAvailable(myToken.getResponseProperties().isWildcardSubscriptionsAvailable());
            this.mqttConnection.setSubscriptionIdentifiersAvailable(myToken.getResponseProperties().isSubscriptionIdentifiersAvailable());
            this.mqttConnection.setSharedSubscriptionsAvailable(myToken.getResponseProperties().isSharedSubscriptionAvailable());
            if (myToken.getResponseProperties().getServerKeepAlive() != null) {
                this.mqttConnection.setKeepAliveSeconds(myToken.getResponseProperties().getServerKeepAlive().intValue());
            }
            if (myToken.getResponseProperties().getAssignedClientIdentifier() != null) {
                this.mqttSession.setClientId(myToken.getResponseProperties().getAssignedClientIdentifier());
                try {
                    this.persistence.open(myToken.getResponseProperties().getAssignedClientIdentifier());
                    if (this.options.isCleanStart()) {
                        this.persistence.clear();
                    }
                }
                catch (MqttPersistenceException exception) {
                    try {
                        this.client.disconnect();
                    }
                    catch (MqttException mqttException) {}
                    this.onFailure(token, exception);
                    return;
                }
            }
        }
        this.userToken.internalTok.markComplete(token.getResponse(), null);
        this.userToken.internalTok.notifyComplete();
        this.userToken.internalTok.setClient(this.client);
        if (this.reconnect) {
            this.comms.notifyReconnect();
        }
        if (this.userCallback != null) {
            this.userToken.setUserContext(this.userContext);
            this.userCallback.onSuccess(this.userToken);
        }
        if (this.mqttCallback != null) {
            String serverURI = this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
            try {
                this.mqttCallback.connectComplete(this.reconnect, serverURI);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void onFailure(IMqttToken token, Throwable exception) {
        int numberOfURIs = this.comms.getNetworkModules().length;
        int index = this.comms.getNetworkModuleIndex();
        if (index + 1 < numberOfURIs) {
            this.comms.setNetworkModuleIndex(index + 1);
            try {
                this.connect();
            }
            catch (MqttPersistenceException e) {
                this.onFailure(token, e);
            }
        } else {
            MqttException ex = exception instanceof MqttException ? (MqttException)exception : new MqttException(exception);
            this.userToken.internalTok.markComplete(null, ex);
            this.userToken.internalTok.notifyComplete();
            this.userToken.internalTok.setClient(this.client);
            if (this.userCallback != null) {
                this.userToken.setUserContext(this.userContext);
                this.userCallback.onFailure(this.userToken, exception);
            }
        }
    }

    public void connect() throws MqttPersistenceException {
        MqttToken token = new MqttToken(this.client.getClientId());
        token.setActionCallback(this);
        token.setUserContext(this);
        if (!this.client.getClientId().equals("")) {
            this.persistence.open(this.client.getClientId());
            if (this.options.isCleanStart()) {
                this.persistence.clear();
            }
        }
        try {
            this.comms.connect(this.options, token);
        }
        catch (MqttException e) {
            this.onFailure(token, e);
        }
    }

    public void setMqttCallbackExtended(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }
}

