/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.internal;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.BufferedMessage;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.DisconnectedBufferOptions;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttToken;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.IDisconnectedBufferCallback;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.Logger;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.LoggerFactory;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttWireMessage;
import java.util.ArrayList;

public class DisconnectedMessageBuffer
implements Runnable {
    private static final String CLASS_NAME = DisconnectedMessageBuffer.class.getName();
    private Logger log = LoggerFactory.getLogger("de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private DisconnectedBufferOptions bufferOpts;
    private ArrayList<BufferedMessage> buffer;
    private final Object bufLock = new Object();
    private IDisconnectedBufferCallback callback;

    public DisconnectedMessageBuffer(DisconnectedBufferOptions options) {
        this.bufferOpts = options;
        this.buffer = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(MqttWireMessage message, MqttToken token) throws MqttException {
        BufferedMessage bufferedMessage = new BufferedMessage(message, token);
        Object object = this.bufLock;
        synchronized (object) {
            if (this.buffer.size() < this.bufferOpts.getBufferSize()) {
                this.buffer.add(bufferedMessage);
            } else if (this.bufferOpts.isDeleteOldestMessages()) {
                this.buffer.remove(0);
                this.buffer.add(bufferedMessage);
            } else {
                throw new MqttException(32203);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedMessage getMessage(int messageIndex) {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.get(messageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(int messageIndex) {
        Object object = this.bufLock;
        synchronized (object) {
            this.buffer.remove(messageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.size();
        }
    }

    @Override
    public void run() {
        this.log.fine(CLASS_NAME, "run", "516");
        while (this.getMessageCount() > 0) {
            try {
                BufferedMessage bufferedMessage = this.getMessage(0);
                this.callback.publishBufferedMessage(bufferedMessage);
                this.deleteMessage(0);
            }
            catch (MqttException ex) {
                if (ex.getReasonCode() == 32202) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.log.warning(CLASS_NAME, "run", "519", new Object[]{ex.getMessage()});
                break;
            }
        }
    }

    public void setPublishCallback(IDisconnectedBufferCallback callback) {
        this.callback = callback;
    }

    public boolean isPersistBuffer() {
        return this.bufferOpts.isPersistBuffer();
    }
}

