/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.internal;

import java.util.concurrent.atomic.AtomicInteger;

public class MqttConnectionState {
    private Integer receiveMaximum = 65535;
    private Integer maximumQoS = 2;
    private Boolean retainAvailable = true;
    private Long outgoingMaximumPacketSize = null;
    private Long incomingMaximumPacketSize = null;
    private Integer outgoingTopicAliasMaximum = 0;
    private Integer incomingTopicAliasMax = 0;
    private Boolean wildcardSubscriptionsAvailable = true;
    private Boolean subscriptionIdentifiersAvailable = true;
    private Boolean sharedSubscriptionsAvailable = true;
    private boolean sendReasonMessages = false;
    private long keepAlive = 60L;
    private String clientId = "";
    private AtomicInteger nextOutgoingTopicAlias = new AtomicInteger(1);

    public MqttConnectionState(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void clearConnectionState() {
        this.nextOutgoingTopicAlias.set(1);
    }

    public Integer getReceiveMaximum() {
        if (this.receiveMaximum == null) {
            return 65535;
        }
        return this.receiveMaximum;
    }

    public void setReceiveMaximum(Integer receiveMaximum) {
        if (receiveMaximum != null) {
            this.receiveMaximum = receiveMaximum;
        }
    }

    public Integer getMaximumQoS() {
        return this.maximumQoS;
    }

    public void setMaximumQoS(Integer maximumQoS) {
        if (maximumQoS != null) {
            this.maximumQoS = maximumQoS;
        }
    }

    public Boolean isRetainAvailable() {
        return this.retainAvailable;
    }

    public void setRetainAvailable(Boolean retainAvailable) {
        if (retainAvailable != null) {
            this.retainAvailable = retainAvailable;
        }
    }

    public Long getOutgoingMaximumPacketSize() {
        return this.outgoingMaximumPacketSize;
    }

    public void setOutgoingMaximumPacketSize(Long maximumPacketSize) {
        if (maximumPacketSize != null) {
            this.outgoingMaximumPacketSize = maximumPacketSize;
        }
    }

    public Long getIncomingMaximumPacketSize() {
        return this.incomingMaximumPacketSize;
    }

    public void setIncomingMaximumPacketSize(Long incomingMaximumPacketSize) {
        if (incomingMaximumPacketSize != null) {
            this.incomingMaximumPacketSize = incomingMaximumPacketSize;
        }
    }

    public Integer getOutgoingTopicAliasMaximum() {
        return this.outgoingTopicAliasMaximum;
    }

    public void setOutgoingTopicAliasMaximum(Integer topicAliasMaximum) {
        if (topicAliasMaximum != null) {
            this.outgoingTopicAliasMaximum = topicAliasMaximum;
        }
    }

    public Boolean isWildcardSubscriptionsAvailable() {
        return this.wildcardSubscriptionsAvailable;
    }

    public void setWildcardSubscriptionsAvailable(Boolean wildcardSubscriptionsAvailable) {
        if (wildcardSubscriptionsAvailable != null) {
            this.wildcardSubscriptionsAvailable = wildcardSubscriptionsAvailable;
        }
    }

    public Boolean isSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable;
    }

    public void setSubscriptionIdentifiersAvailable(Boolean subscriptionIdentifiersAvailable) {
        if (subscriptionIdentifiersAvailable != null) {
            this.subscriptionIdentifiersAvailable = subscriptionIdentifiersAvailable;
        }
    }

    public Boolean isSharedSubscriptionsAvailable() {
        return this.sharedSubscriptionsAvailable;
    }

    public void setSharedSubscriptionsAvailable(Boolean sharedSubscriptionsAvailable) {
        if (sharedSubscriptionsAvailable != null) {
            this.sharedSubscriptionsAvailable = sharedSubscriptionsAvailable;
        }
    }

    public Integer getNextOutgoingTopicAlias() {
        return this.nextOutgoingTopicAlias.getAndIncrement();
    }

    public Integer getIncomingTopicAliasMax() {
        return this.incomingTopicAliasMax;
    }

    public void setIncomingTopicAliasMax(Integer incomingTopicAliasMax) {
        if (incomingTopicAliasMax != null) {
            this.incomingTopicAliasMax = incomingTopicAliasMax;
        }
    }

    public boolean isSendReasonMessages() {
        return this.sendReasonMessages;
    }

    public void setSendReasonMessages(boolean enableReasonMessages) {
        this.sendReasonMessages = enableReasonMessages;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAliveSeconds(long keepAlive) {
        this.keepAlive = keepAlive * 1000L;
    }
}

