/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleLogFormatter
extends Formatter {
    private static final String LS = System.getProperty("line.separator");

    @Override
    public String format(LogRecord r) {
        StringBuffer sb = new StringBuffer();
        sb.append(r.getLevel().getName()).append("\t");
        sb.append(String.valueOf(MessageFormat.format("{0, date, yy-MM-dd} {0, time, kk:mm:ss.SSSS} ", new Date(r.getMillis()))) + "\t");
        String cnm = r.getSourceClassName();
        String cn = "";
        if (cnm != null) {
            int cnl = cnm.length();
            if (cnl > 20) {
                cn = r.getSourceClassName().substring(cnl - 19);
            } else {
                char[] sp = new char[]{' '};
                StringBuffer sb1 = new StringBuffer().append(cnm);
                cn = sb1.append(sp, 0, 1).toString();
            }
        }
        sb.append(cn).append("\t").append(" ");
        sb.append(SimpleLogFormatter.left(r.getSourceMethodName(), 23, ' ')).append("\t");
        sb.append(r.getThreadID()).append("\t");
        sb.append(this.formatMessage(r)).append(LS);
        if (r.getThrown() != null) {
            sb.append("Throwable occurred: ");
            Throwable t = r.getThrown();
            PrintWriter pw = null;
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                sb.append(sw.toString());
            }
            catch (Throwable throwable) {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    public static String left(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        sb.append(s);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        return sb.toString();
    }
}

