/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.Base64;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.HandshakeFailedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WebSocketHandshake {
    private static final String ACCEPT_SALT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String SHA1_PROTOCOL = "SHA1";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    private static final String HTTP_HEADER_UPGRADE = "upgrade";
    private static final String HTTP_HEADER_UPGRADE_WEBSOCKET = "websocket";
    private static final String EMPTY = "";
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String HTTP_HEADER_CONNECTION = "connection";
    private static final String HTTP_HEADER_CONNECTION_VALUE = "upgrade";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    InputStream input;
    OutputStream output;
    String uri;
    String host;
    int port;
    Map<String, String> customWebSocketHeaders;

    public WebSocketHandshake(InputStream input, OutputStream output, String uri, String host, int port, Map<String, String> customWebSocketHeaders) {
        this.input = input;
        this.output = output;
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.customWebSocketHeaders = customWebSocketHeaders;
    }

    public void execute() throws IOException {
        byte[] key = new byte[16];
        System.arraycopy(UUID.randomUUID().toString().getBytes(), 0, key, 0, 16);
        String b64Key = Base64.encodeBytes(key);
        this.sendHandshakeRequest(b64Key);
        this.receiveHandshakeResponse(b64Key);
    }

    private void sendHandshakeRequest(String key) {
        try {
            String userInfo;
            String path = "/mqtt";
            URI srvUri = new URI(this.uri);
            if (srvUri.getRawPath() != null && !srvUri.getRawPath().isEmpty()) {
                path = srvUri.getRawPath();
                if (srvUri.getRawQuery() != null && !srvUri.getRawQuery().isEmpty()) {
                    path = String.valueOf(path) + "?" + srvUri.getRawQuery();
                }
            }
            PrintWriter pw = new PrintWriter(this.output);
            pw.print("GET " + path + " HTTP/1.1" + LINE_SEPARATOR);
            if (this.port != 80 && this.port != 443) {
                pw.print("Host: " + this.host + ":" + this.port + LINE_SEPARATOR);
            } else {
                pw.print("Host: " + this.host + LINE_SEPARATOR);
            }
            pw.print("Upgrade: websocket\r\n");
            pw.print("Connection: Upgrade\r\n");
            pw.print("Sec-WebSocket-Key: " + key + LINE_SEPARATOR);
            pw.print("Sec-WebSocket-Protocol: mqtt\r\n");
            pw.print("Sec-WebSocket-Version: 13\r\n");
            if (this.customWebSocketHeaders != null) {
                this.customWebSocketHeaders.entrySet().forEach(entry -> pw.print(String.valueOf((String)entry.getKey()) + ": " + (String)entry.getValue() + LINE_SEPARATOR));
            }
            if ((userInfo = srvUri.getUserInfo()) != null) {
                pw.print("Authorization: Basic " + Base64.encode(userInfo) + LINE_SEPARATOR);
            }
            pw.print(LINE_SEPARATOR);
            pw.flush();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void receiveHandshakeResponse(String key) throws IOException {
        in = new BufferedReader(new InputStreamReader(this.input));
        responseLines = new ArrayList<String>();
        line = in.readLine();
        if (line != null) ** GOTO lbl9
        throw new IOException("WebSocket Response header: Invalid response from Server, It may not support WebSockets.");
lbl-1000:
        // 1 sources

        {
            responseLines.add(line);
            line = in.readLine();
lbl9:
            // 2 sources

            ** while (!line.equals((Object)""))
        }
lbl10:
        // 1 sources

        headerMap = this.getHeaders(responseLines);
        connectionHeader = headerMap.get("connection");
        if (connectionHeader == null || connectionHeader.equalsIgnoreCase("upgrade")) {
            throw new IOException("WebSocket Response header: Incorrect connection header");
        }
        upgradeHeader = headerMap.get("upgrade");
        if (upgradeHeader == null || !upgradeHeader.toLowerCase().contains("websocket")) {
            throw new IOException("WebSocket Response header: Incorrect upgrade.");
        }
        secWebsocketProtocolHeader = headerMap.get("sec-websocket-protocol");
        if (secWebsocketProtocolHeader == null) {
            throw new IOException("WebSocket Response header: empty sec-websocket-protocol");
        }
        if (!headerMap.containsKey("sec-websocket-accept")) {
            throw new IOException("WebSocket Response header: Missing Sec-WebSocket-Accept");
        }
        try {
            this.verifyWebSocketKey(key, headerMap.get("sec-websocket-accept"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        catch (HandshakeFailedException v0) {
            throw new IOException("WebSocket Response header: Incorrect Sec-WebSocket-Key");
        }
    }

    private Map<String, String> getHeaders(ArrayList<String> headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        int i = 1;
        while (i < headers.size()) {
            String headerPre = headers.get(i);
            String[] header = headerPre.split(":");
            headerMap.put(header[0].toLowerCase(), header[1]);
            ++i;
        }
        return headerMap;
    }

    private void verifyWebSocketKey(String key, String accept) throws NoSuchAlgorithmException, HandshakeFailedException {
        byte[] sha1Bytes = this.sha1(String.valueOf(key) + ACCEPT_SALT);
        String encodedSha1Bytes = Base64.encodeBytes(sha1Bytes).trim();
        if (!encodedSha1Bytes.equals(accept.trim())) {
            throw new HandshakeFailedException();
        }
    }

    private byte[] sha1(String input) throws NoSuchAlgorithmException {
        MessageDigest mDigest = MessageDigest.getInstance(SHA1_PROTOCOL);
        return mDigest.digest(input.getBytes());
    }
}

