/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.SSLNetworkModule;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.Logger;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.LoggerFactory;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.ExtendedByteArrayOutputStream;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.WebSocketFrame;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.WebSocketHandshake;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.WebSocketReceiver;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketSecureNetworkModule
extends SSLNetworkModule {
    private static final String CLASS_NAME = WebSocketSecureNetworkModule.class.getName();
    private Logger log = LoggerFactory.getLogger("de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private PipedInputStream pipedInputStream;
    private WebSocketReceiver webSocketReceiver;
    private String uri;
    private String host;
    private int port;
    ByteBuffer recievedPayload;
    Map<String, String> customWebSocketHeaders;
    private ByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream(this);

    public WebSocketSecureNetworkModule(SSLSocketFactory factory, String uri, String host, int port, String clientId) {
        super(factory, host, port, clientId);
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.pipedInputStream = new PipedInputStream();
        this.log.setResourceName(clientId);
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        WebSocketHandshake handshake = new WebSocketHandshake(super.getInputStream(), super.getOutputStream(), this.uri, this.host, this.port, this.customWebSocketHeaders);
        handshake.execute();
        this.webSocketReceiver = new WebSocketReceiver(this.getSocketInputStream(), this.pipedInputStream);
        this.webSocketReceiver.start("WssSocketReceiver");
    }

    OutputStream getSocketOutputStream() throws IOException {
        return super.getOutputStream();
    }

    InputStream getSocketInputStream() throws IOException {
        return super.getInputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.pipedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void setCustomWebSocketHeaders(Map<String, String> customWebSocketHeaders) {
        this.customWebSocketHeaders = customWebSocketHeaders;
    }

    @Override
    public void stop() throws IOException {
        WebSocketFrame frame = new WebSocketFrame(8, true, "1000".getBytes());
        byte[] rawFrame = frame.encodeFrame();
        this.getSocketOutputStream().write(rawFrame);
        this.getSocketOutputStream().flush();
        if (this.webSocketReceiver != null) {
            this.webSocketReceiver.stop();
        }
        super.stop();
    }

    @Override
    public String getServerURI() {
        return "wss://" + this.host + ":" + this.port;
    }
}

