/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttConnectionOptions;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.NetworkModule;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.security.SSLSocketFactoryFactory;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.spi.NetworkModuleFactory;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.websocket.WebSocketSecureNetworkModule;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.ExceptionHelper;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketSecureNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("wss")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectionOptions options, String clientId) throws MqttException {
        String[] enabledCiphers;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 443;
        }
        SocketFactory factory = options.getSocketFactory();
        SSLSocketFactoryFactory wSSFactoryFactory = null;
        if (factory == null) {
            wSSFactoryFactory = new SSLSocketFactoryFactory();
            Properties sslClientProps = options.getSSLProperties();
            if (sslClientProps != null) {
                wSSFactoryFactory.initialize(sslClientProps, null);
            }
            factory = wSSFactoryFactory.createSocketFactory(null);
        } else if (!(factory instanceof SSLSocketFactory)) {
            throw ExceptionHelper.createMqttException(32105);
        }
        WebSocketSecureNetworkModule netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory, brokerUri.toString(), host, port, clientId);
        netModule.setSSLhandshakeTimeout(options.getConnectionTimeout());
        netModule.setSSLHostnameVerifier(options.getSSLHostnameVerifier());
        netModule.setHttpsHostnameVerificationEnabled(options.isHttpsHostnameVerificationEnabled());
        netModule.setCustomWebSocketHeaders(options.getCustomWebSocketHeaders());
        if (wSSFactoryFactory != null && (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) != null) {
            netModule.setEnabledCiphers(enabledCiphers);
        }
        return netModule;
    }
}

