/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.client.wire;

import de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.MqttState;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.Logger;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.logging.LoggerFactory;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.ExceptionHelper;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttDataTypes;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttWireMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class MqttInputStream
extends InputStream {
    private static final String CLASS_NAME = MqttInputStream.class.getName();
    private Logger log = LoggerFactory.getLogger("de.themoep.connectorplugin.lib.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private MqttState clientState = null;
    private DataInputStream in;
    private ByteArrayOutputStream bais;
    private int remLen;
    private int packetLen;
    private byte[] packet;

    public MqttInputStream(MqttState clientState, InputStream in, String clientId) {
        this.clientState = clientState;
        this.in = new DataInputStream(in);
        this.bais = new ByteArrayOutputStream();
        this.remLen = -1;
        this.log.setResourceName(clientId);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() throws IOException, MqttException {
        MqttWireMessage message = null;
        try {
            if (this.remLen < 0) {
                this.bais.reset();
                byte first = this.in.readByte();
                this.clientState.notifyReceivedBytes(1);
                byte type = (byte)(first >>> 4 & 0xF);
                if (type < 1 || type > 15) {
                    throw ExceptionHelper.createMqttException(32108);
                }
                byte reserved = (byte)(first & 0xF);
                MqttWireMessage.validateReservedBits(type, reserved);
                this.remLen = MqttDataTypes.readVariableByteInteger(this.in).getValue();
                this.bais.write(first);
                this.bais.write(MqttWireMessage.encodeVariableByteInteger(this.remLen));
                this.packet = new byte[this.bais.size() + this.remLen];
                if (this.clientState.getIncomingMaximumPacketSize() != null && (long)(this.bais.size() + this.remLen) > this.clientState.getIncomingMaximumPacketSize()) {
                    throw ExceptionHelper.createMqttException(51001);
                }
                this.packetLen = 0;
            }
            if (this.remLen >= 0) {
                this.readFully();
                this.remLen = -1;
                byte[] header = this.bais.toByteArray();
                System.arraycopy(header, 0, this.packet, 0, header.length);
                message = MqttWireMessage.createWireMessage(this.packet);
                this.log.fine(CLASS_NAME, "readMqttWireMessage", "530", new Object[]{message});
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {}
        return message;
    }

    private void readFully() throws IOException {
        int off = this.bais.size() + this.packetLen;
        int len = this.remLen - this.packetLen;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = -1;
            try {
                count = this.in.read(this.packet, off + n, len - n);
            }
            catch (SocketTimeoutException e) {
                this.packetLen += n;
                throw e;
            }
            if (count < 0) {
                throw new EOFException();
            }
            this.clientState.notifyReceivedBytes(count);
            n += count;
        }
    }
}

