/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common;

import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttProperties;

public class MqttMessage {
    private boolean mutable = true;
    private byte[] payload;
    private int qos = 1;
    private boolean retained = false;
    private boolean dup = false;
    private int messageId;
    private MqttProperties properties;

    public static void validateQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException();
        }
    }

    public MqttMessage() {
        this.setPayload(new byte[0]);
    }

    public MqttMessage(byte[] payload) {
        this.setPayload(payload);
    }

    public MqttMessage(byte[] payload, int qos, boolean retained, MqttProperties properties) {
        this.setPayload(payload);
        this.setQos(qos);
        this.setRetained(retained);
        this.setProperties(properties);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void clearPayload() {
        this.checkMutable();
        this.payload = new byte[0];
    }

    public void setPayload(byte[] payload) {
        this.checkMutable();
        if (payload == null) {
            throw new NullPointerException();
        }
        this.payload = payload;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean retained) {
        this.checkMutable();
        this.retained = retained;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.checkMutable();
        MqttMessage.validateQos(qos);
        this.qos = qos;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    protected void checkMutable() throws IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
    }

    public void setDuplicate(boolean dup) {
        this.dup = dup;
    }

    public boolean isDuplicate() {
        return this.dup;
    }

    public void setId(int messageId) {
        this.messageId = messageId;
    }

    public int getId() {
        return this.messageId;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public String toString() {
        return new String(this.payload);
    }

    public String toDebugString() {
        return "MqttMessage [mutable=" + this.mutable + ", payload=" + new String(this.payload) + ", qos=" + this.qos + ", retained=" + this.retained + ", dup=" + this.dup + ", messageId=" + this.messageId + "]";
    }
}

