/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common;

public class MqttSubscription {
    private boolean mutable = true;
    private String topic;
    private int qos = 1;
    private boolean noLocal = false;
    private boolean retainAsPublished = false;
    private int retainHandling = 0;
    private int messageId;

    public MqttSubscription(String topic) {
        this.setTopic(topic);
    }

    public MqttSubscription(String topic, int qos) {
        this.setTopic(topic);
        this.setQos(qos);
    }

    public static void validateQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException();
        }
    }

    public static void validateRetainHandling(int retainHandling) {
        if (retainHandling < 0 || retainHandling > 2) {
            throw new IllegalArgumentException();
        }
    }

    protected void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    protected void checkMutable() throws IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.checkMutable();
        if (topic == null) {
            throw new NullPointerException();
        }
        this.topic = topic;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.checkMutable();
        MqttSubscription.validateQos(qos);
        this.qos = qos;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.checkMutable();
        this.noLocal = noLocal;
    }

    public boolean isRetainAsPublished() {
        return this.retainAsPublished;
    }

    public void setRetainAsPublished(boolean retainAsPublished) {
        this.checkMutable();
        this.retainAsPublished = retainAsPublished;
    }

    public int getRetainHandling() {
        return this.retainHandling;
    }

    public void setRetainHandling(int retainHandling) {
        this.checkMutable();
        MqttSubscription.validateRetainHandling(retainHandling);
        this.retainHandling = retainHandling;
    }

    public String toString() {
        return "MqttSubscription [mutable=" + this.mutable + ", topic=" + this.topic + ", qos=" + this.qos + ", noLocal=" + this.noLocal + ", retainAsPublished=" + this.retainAsPublished + ", retainHandling=" + this.retainHandling + "]";
    }

    public void setId(int messageId) {
        this.messageId = messageId;
    }

    public int getId() {
        return this.messageId;
    }
}

