/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common.packet;

import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttProperties;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttWireMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MqttAuth
extends MqttWireMessage {
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[3];
        nArray[1] = 24;
        nArray[2] = 25;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)21, (byte)22, (byte)31, (byte)38};
    }

    public MqttAuth(byte[] data) throws IOException, MqttException {
        super((byte)15);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream inputStream = new DataInputStream(bais);
        this.reasonCode = inputStream.readUnsignedByte();
        this.validateReturnCode(this.reasonCode, validReturnCodes);
        this.properties.decodeProperties(inputStream);
        inputStream.close();
    }

    public MqttAuth(int returnCode, MqttProperties properties) throws MqttException {
        super((byte)15);
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
        this.validateReturnCode(returnCode, validReturnCodes);
        this.reasonCode = returnCode;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeByte(this.reasonCode);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            outputStream.write(identifierValueFieldsByteArray);
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    protected byte getMessageInfo() {
        return 1;
    }

    public int getReturnCode() {
        return this.reasonCode;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttAuth [returnCode=" + this.reasonCode + ", properties=" + this.properties + "]";
    }
}

