/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common.packet;

import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttMessage;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttDataTypes;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttPacketException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttProperties;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttWireMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class MqttConnect
extends MqttWireMessage {
    public static final String KEY = "Con";
    private MqttProperties properties;
    private MqttProperties willProperties;
    private byte info;
    private String clientId;
    private boolean reservedByte;
    private boolean cleanStart;
    private MqttMessage willMessage;
    private String userName;
    private byte[] password;
    private int keepAliveInterval;
    private String willDestination;
    private int mqttVersion = 5;
    private static final Byte[] validProperties = new Byte[]{(byte)17, (byte)24, (byte)33, (byte)39, (byte)34, (byte)25, (byte)23, (byte)38, (byte)21, (byte)22};
    private static final Byte[] validWillProperties = new Byte[]{(byte)24, (byte)1, (byte)2, (byte)8, (byte)9, (byte)38, (byte)3};

    public MqttConnect(byte info2, byte[] data) throws IOException, MqttException {
        super((byte)1);
        boolean usernameFlag;
        this.info = info2;
        this.properties = new MqttProperties(validProperties);
        this.willProperties = new MqttProperties(validWillProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        String protocolName = MqttDataTypes.decodeUTF8(dis);
        if (!protocolName.equalsIgnoreCase("MQTT")) {
            throw new MqttPacketException(51000);
        }
        this.mqttVersion = dis.readByte();
        if (this.mqttVersion != 5) {
            throw new MqttPacketException(51001);
        }
        byte connectFlags = dis.readByte();
        this.reservedByte = (connectFlags & 1) != 0;
        this.cleanStart = (connectFlags & 2) != 0;
        boolean willFlag = (connectFlags & 4) != 0;
        int willQoS = connectFlags >> 3 & 3;
        boolean willRetain = (connectFlags & 0x20) != 0;
        boolean passwordFlag = (connectFlags & 0x40) != 0;
        boolean bl = usernameFlag = (connectFlags & 0x80) != 0;
        if (this.reservedByte) {
            throw new MqttPacketException(51002);
        }
        this.keepAliveInterval = dis.readUnsignedShort();
        this.properties.decodeProperties(dis);
        this.clientId = MqttDataTypes.decodeUTF8(dis);
        if (willFlag) {
            this.willProperties.decodeProperties(dis);
            if (willQoS == 3) {
                throw new MqttPacketException(51003);
            }
            this.willDestination = MqttDataTypes.decodeUTF8(dis);
            short willMessageLength = dis.readShort();
            byte[] willMessageBytes = new byte[willMessageLength];
            dis.read(willMessageBytes, 0, willMessageLength);
            this.willMessage = new MqttMessage(willMessageBytes);
            this.willMessage.setQos(willQoS);
            this.willMessage.setRetained(willRetain);
        }
        if (usernameFlag) {
            this.userName = MqttDataTypes.decodeUTF8(dis);
        }
        if (passwordFlag) {
            short passwordLength = dis.readShort();
            this.password = new byte[passwordLength];
            dis.read(this.password, 0, passwordLength);
        }
        dis.close();
    }

    public MqttConnect(String clientId, int mqttVersion, boolean cleanStart, int keepAliveInterval, MqttProperties properties, MqttProperties willProperties) {
        super((byte)1);
        this.clientId = clientId;
        this.mqttVersion = mqttVersion;
        this.cleanStart = cleanStart;
        this.keepAliveInterval = keepAliveInterval;
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
        this.willProperties = willProperties;
        this.willProperties.setValidProperties(validWillProperties);
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanStart() {
        return this.cleanStart;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            MqttDataTypes.encodeUTF8(dos, "MQTT");
            dos.write(this.mqttVersion);
            int connectFlags = 0;
            if (this.cleanStart) {
                connectFlags = (byte)(connectFlags | 2);
            }
            if (this.willMessage != null) {
                connectFlags = (byte)(connectFlags | 4);
                connectFlags = (byte)(connectFlags | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    connectFlags = (byte)(connectFlags | 0x20);
                }
            }
            if (this.userName != null) {
                connectFlags = (byte)(connectFlags | 0x80);
            }
            if (this.password != null) {
                connectFlags = (byte)(connectFlags | 0x40);
            }
            dos.write(connectFlags);
            dos.writeShort(this.keepAliveInterval);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            dos.write(identifierValueFieldsByteArray);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            MqttDataTypes.encodeUTF8(dos, this.clientId);
            if (this.willMessage != null) {
                byte[] willIdentifierValueFieldsByteArray = this.willProperties.encodeProperties();
                dos.write(willIdentifierValueFieldsByteArray);
                MqttDataTypes.encodeUTF8(dos, this.willDestination);
                dos.writeShort(this.willMessage.getPayload().length);
                dos.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                MqttDataTypes.encodeUTF8(dos, this.userName);
            }
            if (this.password != null) {
                dos.writeShort(this.password.length);
                dos.write(this.password);
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public void setWillMessage(MqttMessage willMessage) {
        this.willMessage = willMessage;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public void setWillDestination(String willDestination) {
        this.willDestination = willDestination;
    }

    public byte getInfo() {
        return this.info;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public String getUserName() {
        return this.userName;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getWillDestination() {
        return this.willDestination;
    }

    public int getMqttVersion() {
        return this.mqttVersion;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttProperties getWillProperties() {
        return this.willProperties;
    }

    @Override
    public String toString() {
        return "MqttConnect [properties=" + this.properties + ", willProperties=" + this.willProperties + ", info=" + this.info + ", clientId=" + this.clientId + ", reservedByte=" + this.reservedByte + ", cleanStart=" + this.cleanStart + ", willMessage=" + this.willMessage + ", userName=" + this.userName + ", password=" + Arrays.toString(this.password) + ", keepAliveInterval=" + this.keepAliveInterval + ", willDestination=" + this.willDestination + ", mqttVersion=" + this.mqttVersion + "]";
    }
}

