/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common.packet;

import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttPersistableWireMessage;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttProperties;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.util.CountingInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MqttPubRel
extends MqttPersistableWireMessage {
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[2];
        nArray[1] = 146;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)31, (byte)38};
    }

    public MqttPubRel(byte[] data) throws IOException, MqttException {
        super((byte)6);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream dis = new DataInputStream(counter);
        this.msgId = dis.readUnsignedShort();
        long remainder = (long)data.length - (long)counter.getCounter();
        if (remainder >= 1L) {
            this.reasonCode = dis.readUnsignedByte();
            this.validateReturnCode(this.reasonCode, validReturnCodes);
        } else {
            this.reasonCode = 0;
        }
        if (remainder >= 4L) {
            this.properties.decodeProperties(dis);
        }
        dis.close();
    }

    public MqttPubRel(int returnCode, int msgId, MqttProperties properties) throws MqttException {
        super((byte)6);
        this.validateReturnCode(returnCode, validReturnCodes);
        this.reasonCode = returnCode;
        this.msgId = msgId;
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeShort(this.msgId);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            if (this.reasonCode != 0 && identifierValueFieldsByteArray.length == 1) {
                outputStream.write((byte)this.reasonCode);
            } else if (this.reasonCode != 0 || identifierValueFieldsByteArray.length > 1) {
                outputStream.write((byte)this.reasonCode);
                outputStream.write(identifierValueFieldsByteArray);
            }
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    public int getReturnCode() {
        return this.reasonCode;
    }

    public void setReturnCode(int returnCode) {
        this.reasonCode = returnCode;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttPubRel [returnCode=" + this.reasonCode + ", properties=" + this.properties + "]";
    }
}

