/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common.packet;

import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttSubscription;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttDataTypes;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttPersistableWireMessage;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttProperties;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.util.CountingInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class MqttSubscribe
extends MqttPersistableWireMessage {
    private static final Byte[] validProperties = new Byte[]{(byte)11, (byte)127, (byte)38};
    private MqttProperties properties;
    private MqttSubscription[] subscriptions;

    public MqttSubscribe(byte[] data) throws IOException, MqttException {
        super((byte)8);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream inputStream = new DataInputStream(counter);
        this.msgId = inputStream.readUnsignedShort();
        this.properties.decodeProperties(inputStream);
        ArrayList<MqttSubscription> subscriptionList = new ArrayList<MqttSubscription>();
        while (counter.getCounter() < data.length) {
            String topic = MqttDataTypes.decodeUTF8(inputStream);
            byte subscriptionOptions = inputStream.readByte();
            subscriptionList.add(this.decodeSubscription(topic, subscriptionOptions));
        }
        this.subscriptions = subscriptionList.toArray(new MqttSubscription[subscriptionList.size()]);
        inputStream.close();
    }

    public MqttSubscribe(MqttSubscription[] subscriptions, MqttProperties properties) {
        super((byte)8);
        this.subscriptions = subscriptions;
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    public MqttSubscribe(MqttSubscription subscription, MqttProperties properties) {
        super((byte)8);
        this.subscriptions = new MqttSubscription[]{subscription};
        this.properties = properties;
        this.properties.setValidProperties(validProperties);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeShort(this.msgId);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            outputStream.write(identifierValueFieldsByteArray);
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            MqttSubscription[] mqttSubscriptionArray = this.subscriptions;
            int n = this.subscriptions.length;
            int n2 = 0;
            while (n2 < n) {
                MqttSubscription subscription = mqttSubscriptionArray[n2];
                outputStream.write(this.encodeSubscription(subscription));
                ++n2;
            }
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    private byte[] encodeSubscription(MqttSubscription subscription) throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            MqttDataTypes.encodeUTF8(outputStream, subscription.getTopic());
            byte subscriptionOptions = (byte)subscription.getQos();
            if (subscription.isNoLocal()) {
                subscriptionOptions = (byte)(subscriptionOptions | 4);
            }
            if (subscription.isRetainAsPublished()) {
                subscriptionOptions = (byte)(subscriptionOptions | 8);
            }
            subscriptionOptions = (byte)(subscriptionOptions | subscription.getRetainHandling() << 4);
            outputStream.write(subscriptionOptions);
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    private MqttSubscription decodeSubscription(String topic, byte subscriptionOptions) {
        MqttSubscription subscription = new MqttSubscription(topic);
        subscription.setQos(subscriptionOptions & 3);
        subscription.setNoLocal((subscriptionOptions & 4) != 0);
        subscription.setRetainAsPublished((subscriptionOptions & 8) != 0);
        subscription.setRetainHandling(subscriptionOptions >> 4 & 3);
        return subscription;
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    public MqttSubscription[] getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttSubscribe [properties=" + this.properties + ", subscriptions=" + Arrays.toString(this.subscriptions) + "]";
    }
}

