/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.paho.mqttv5.common.packet;

import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttAck;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.MqttProperties;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.packet.util.CountingInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class MqttUnsubAck
extends MqttAck {
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[7];
        nArray[1] = 17;
        nArray[2] = 128;
        nArray[3] = 131;
        nArray[4] = 135;
        nArray[5] = 143;
        nArray[6] = 145;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)31, (byte)38};
    }

    public MqttUnsubAck(byte[] data) throws IOException, MqttException {
        super((byte)11);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream inputStream = new DataInputStream(counter);
        this.msgId = inputStream.readUnsignedShort();
        this.properties.decodeProperties(inputStream);
        int remainingLengh = data.length - counter.getCounter();
        this.reasonCodes = new int[remainingLengh];
        int i = 0;
        while (i < remainingLengh) {
            this.reasonCodes[i] = inputStream.readUnsignedByte();
            this.validateReturnCode(this.reasonCodes[i], validReturnCodes);
            ++i;
        }
        inputStream.close();
    }

    public MqttUnsubAck(int[] returnCodes, MqttProperties properties) throws MqttException {
        super((byte)11);
        int[] nArray = returnCodes;
        int n = returnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int returnCode = nArray[n2];
            this.validateReturnCode(returnCode, validReturnCodes);
            ++n2;
        }
        this.reasonCodes = returnCodes;
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeShort(this.msgId);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            outputStream.write(identifierValueFieldsByteArray);
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            int[] nArray = this.reasonCodes;
            int n = this.reasonCodes.length;
            int n2 = 0;
            while (n2 < n) {
                int returnCode = nArray[n2];
                outputStream.writeByte(returnCode);
                ++n2;
            }
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public int[] getReturnCodes() {
        return this.reasonCodes;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttUnsubAck [returnCodes=" + Arrays.toString(this.reasonCodes) + ", properties=" + this.properties + "]";
    }
}

