/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactivestreams.Subscription;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Exceptions;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalFluxOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import java.util.Objects;
import java.util.function.Function;

final class FluxOnErrorResume<T>
extends InternalFluxOperator<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;

    FluxOnErrorResume(Flux<? extends T> source, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
        super(source);
        this.nextFactory = Objects.requireNonNull(nextFactory, "nextFactory");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new ResumeSubscriber<T>(actual, this.nextFactory);
    }

    static final class ResumeSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;
        boolean second;

        ResumeSubscriber(CoreSubscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
            super(actual);
            this.nextFactory = nextFactory;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (!this.second) {
                this.actual.onSubscribe(this);
            }
            this.set(s);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
            if (!this.second) {
                this.producedOne();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.second) {
                Publisher<T> p;
                this.second = true;
                try {
                    p = Objects.requireNonNull(this.nextFactory.apply(t), "The nextFactory returned a null Publisher");
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e, this.actual.currentContext());
                    _e = Exceptions.addSuppressed(_e, t);
                    this.actual.onError(_e);
                    return;
                }
                p.subscribe(this);
            } else {
                this.actual.onError(t);
            }
        }
    }
}

