/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Processor;
import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactivestreams.Subscriber;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Disposable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.DelegateProcessor;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxCreate;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxSink;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.core.publisher.UnicastProcessor;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import de.themoep.connectorplugin.lib.reactor.util.context.Context;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;

public abstract class FluxProcessor<IN, OUT>
extends Flux<OUT>
implements Processor<IN, OUT>,
CoreSubscriber<IN>,
Scannable,
Disposable {
    public static <T> FluxProcessor<Publisher<? extends T>, T> switchOnNext() {
        UnicastProcessor emitter = UnicastProcessor.create();
        FluxProcessor p = FluxProcessor.wrap(emitter, FluxProcessor.switchOnNext(emitter));
        return p;
    }

    public static <IN, OUT> FluxProcessor<IN, OUT> wrap(Subscriber<IN> upstream, Publisher<OUT> downstream) {
        return new DelegateProcessor<IN, OUT>(downstream, upstream);
    }

    @Override
    public void dispose() {
        this.onError(new CancellationException("Disposed"));
    }

    public long downstreamCount() {
        return this.inners().count();
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public Throwable getError() {
        return null;
    }

    public boolean hasDownstreams() {
        return this.downstreamCount() != 0L;
    }

    public final boolean hasCompleted() {
        return this.isTerminated() && this.getError() == null;
    }

    public final boolean hasError() {
        return this.isTerminated() && this.getError() != null;
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.empty();
    }

    public boolean isTerminated() {
        return false;
    }

    public boolean isSerialized() {
        return false;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.TERMINATED) {
            return this.isTerminated();
        }
        if (key == Scannable.Attr.ERROR) {
            return this.getError();
        }
        if (key == Scannable.Attr.CAPACITY) {
            return this.getBufferSize();
        }
        return null;
    }

    @Override
    public Context currentContext() {
        return Context.empty();
    }

    public final FluxProcessor<IN, OUT> serialize() {
        return new DelegateProcessor(this, Operators.serialize(this));
    }

    public final FluxSink<IN> sink() {
        return this.sink(FluxSink.OverflowStrategy.IGNORE);
    }

    public final FluxSink<IN> sink(FluxSink.OverflowStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy");
        if (this.getBufferSize() == Integer.MAX_VALUE) {
            strategy = FluxSink.OverflowStrategy.IGNORE;
        }
        FluxCreate.BaseSink s = FluxCreate.createSink(this, strategy);
        this.onSubscribe(s);
        if (s.isCancelled() || this.isSerialized() && this.getBufferSize() == Integer.MAX_VALUE) {
            return s;
        }
        if (this.serializeAlways()) {
            return new FluxCreate.SerializedSink(s);
        }
        return new FluxCreate.SerializeOnRequestSink(s);
    }

    protected boolean serializeAlways() {
        return true;
    }
}

