/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.CorePublisher;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Exceptions;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalFluxOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;

final class FluxRetryPredicate<T>
extends InternalFluxOperator<T, T> {
    final Predicate<? super Throwable> predicate;

    FluxRetryPredicate(Flux<? extends T> source, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        RetryPredicateSubscriber<T> parent = new RetryPredicateSubscriber<T>(this.source, actual, this.predicate);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
        return null;
    }

    static final class RetryPredicateSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final CorePublisher<? extends T> source;
        final Predicate<? super Throwable> predicate;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetryPredicateSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetryPredicateSubscriber.class, "wip");
        long produced;

        RetryPredicateSubscriber(CorePublisher<? extends T> source, CoreSubscriber<? super T> actual, Predicate<? super Throwable> predicate) {
            super(actual);
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable e) {
                Throwable _t = Operators.onOperatorError(e, this.actual.currentContext());
                _t = Exceptions.addSuppressed(_t, t);
                this.actual.onError(_t);
                return;
            }
            if (b) {
                this.resubscribe();
            } else {
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        void resubscribe() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    this.source.subscribe(this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

