/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactivestreams.Subscriber;
import de.themoep.connectorplugin.lib.reactivestreams.Subscription;
import de.themoep.connectorplugin.lib.reactor.core.CorePublisher;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.DirectProcessor;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InnerConsumer;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalFluxOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.core.publisher.OptimizableOperator;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import de.themoep.connectorplugin.lib.reactor.util.context.Context;
import de.themoep.connectorplugin.lib.reactor.util.retry.Retry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Stream;

final class FluxRetryWhen<T>
extends InternalFluxOperator<T, T> {
    final Retry whenSourceFactory;

    FluxRetryWhen(Flux<? extends T> source, Retry whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    static <T> void subscribe(CoreSubscriber<? super T> s, Retry whenSourceFactory, CorePublisher<? extends T> source) {
        Publisher<?> p;
        RetryWhenOtherSubscriber other = new RetryWhenOtherSubscriber();
        CoreSubscriber<Retry.RetrySignal> signaller = Operators.serialize(other.completionSignal);
        signaller.onSubscribe(Operators.emptySubscription());
        CoreSubscriber<T> serial = Operators.serialize(s);
        RetryWhenMainSubscriber<? extends T> main = new RetryWhenMainSubscriber<T>(serial, signaller, source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = Objects.requireNonNull(whenSourceFactory.generateCompanion(other), "The whenSourceFactory returned a null Publisher");
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e, s.currentContext()));
            return;
        }
        p.subscribe(other);
        if (!main.cancelled) {
            source.subscribe((CoreSubscriber<? extends T>)main);
        }
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        FluxRetryWhen.subscribe(actual, this.whenSourceFactory, this.source);
        return null;
    }

    static final class RetryWhenOtherSubscriber
    extends Flux<Retry.RetrySignal>
    implements InnerConsumer<Object>,
    OptimizableOperator<Retry.RetrySignal, Retry.RetrySignal> {
        RetryWhenMainSubscriber<?> main;
        final DirectProcessor<Retry.RetrySignal> completionSignal = new DirectProcessor();

        RetryWhenOtherSubscriber() {
        }

        @Override
        public Context currentContext() {
            return this.main.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.main.otherArbiter;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.main;
            }
            return null;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.main.swap(s);
        }

        @Override
        public void onNext(Object t) {
            this.main.resubscribe(t);
        }

        @Override
        public void onError(Throwable t) {
            this.main.whenError(t);
        }

        @Override
        public void onComplete() {
            this.main.whenComplete();
        }

        @Override
        public void subscribe(CoreSubscriber<? super Retry.RetrySignal> actual) {
            this.completionSignal.subscribe(actual);
        }

        @Override
        public CoreSubscriber<? super Retry.RetrySignal> subscribeOrReturn(CoreSubscriber<? super Retry.RetrySignal> actual) {
            return actual;
        }

        @Override
        public DirectProcessor<Retry.RetrySignal> source() {
            return this.completionSignal;
        }

        @Override
        public OptimizableOperator<?, ? extends Retry.RetrySignal> nextOptimizableSource() {
            return null;
        }
    }

    static final class RetryWhenMainSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T>
    implements Retry.RetrySignal {
        final Operators.DeferredSubscription otherArbiter;
        final Subscriber<Retry.RetrySignal> signaller;
        final CorePublisher<? extends T> source;
        long totalFailureIndex = 0L;
        long subsequentFailureIndex = 0L;
        @Nullable
        Throwable lastFailure = null;
        Context context;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetryWhenMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetryWhenMainSubscriber.class, "wip");
        long produced;

        RetryWhenMainSubscriber(CoreSubscriber<? super T> actual, Subscriber<Retry.RetrySignal> signaller, CorePublisher<? extends T> source) {
            super(actual);
            this.signaller = signaller;
            this.source = source;
            this.otherArbiter = new Operators.DeferredSubscription();
            this.context = actual.currentContext();
        }

        @Override
        public long totalRetries() {
            return this.totalFailureIndex - 1L;
        }

        @Override
        public long totalRetriesInARow() {
            return this.subsequentFailureIndex - 1L;
        }

        @Override
        public Throwable failure() {
            assert (this.lastFailure != null);
            return this.lastFailure;
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.signaller), this.otherArbiter);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.otherArbiter.cancel();
                super.cancel();
            }
        }

        void swap(Subscription w) {
            this.otherArbiter.set(w);
        }

        @Override
        public void onNext(T t) {
            this.subsequentFailureIndex = 0L;
            this.actual.onNext(t);
            ++this.produced;
        }

        @Override
        public void onError(Throwable t) {
            ++this.totalFailureIndex;
            ++this.subsequentFailureIndex;
            this.lastFailure = t;
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.otherArbiter.request(1L);
            this.signaller.onNext(this);
        }

        @Override
        public void onComplete() {
            this.lastFailure = null;
            this.otherArbiter.cancel();
            this.actual.onComplete();
        }

        void resubscribe(Object trigger) {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (trigger instanceof Context) {
                        this.context = this.context.putAll((Context)trigger);
                    }
                    this.source.subscribe(this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }

        void whenError(Throwable e) {
            super.cancel();
            this.actual.onError(e);
        }

        void whenComplete() {
            super.cancel();
            this.actual.onComplete();
        }
    }
}

