/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Exceptions;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.AssemblyOp;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxOnAssembly;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalMonoOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.concurrent.Callable;

final class MonoCallableOnAssembly<T>
extends InternalMonoOperator<T, T>
implements Callable<T>,
AssemblyOp {
    final FluxOnAssembly.AssemblySnapshot stacktrace;

    MonoCallableOnAssembly(Mono<? extends T> source, FluxOnAssembly.AssemblySnapshot stacktrace) {
        super(source);
        this.stacktrace = stacktrace;
    }

    @Override
    @Nullable
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    @Nullable
    public T block(Duration timeout) {
        try {
            return (T)((Callable)((Object)this.source)).call();
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            return new FluxOnAssembly.OnAssemblyConditionalSubscriber(cs, this.stacktrace, (Publisher<?>)this.source);
        }
        return new FluxOnAssembly.OnAssemblySubscriber<T>(actual, this.stacktrace, this.source);
    }

    @Override
    @Nullable
    public T call() throws Exception {
        return (T)((Callable)((Object)this.source)).call();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL_METADATA) {
            return !this.stacktrace.checkpointed;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public String stepName() {
        return this.stacktrace.operatorAssemblyInformation();
    }

    @Override
    public String toString() {
        return this.stacktrace.operatorAssemblyInformation();
    }
}

