/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Subscription;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.MonoFromFluxOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import java.util.Objects;

final class MonoElementAt<T>
extends MonoFromFluxOperator<T, T>
implements Fuseable {
    final long index;
    final T defaultValue;

    MonoElementAt(Flux<? extends T> source, long index) {
        super(source);
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= required but it was " + index);
        }
        this.index = index;
        this.defaultValue = null;
    }

    MonoElementAt(Flux<? extends T> source, long index, T defaultValue) {
        super(source);
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= required but it was " + index);
        }
        this.index = index;
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new ElementAtSubscriber<T>(actual, this.index, this.defaultValue);
    }

    static final class ElementAtSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final T defaultValue;
        long index;
        final long target;
        Subscription s;
        boolean done;

        ElementAtSubscriber(CoreSubscriber<? super T> actual, long index, T defaultValue) {
            super(actual);
            this.index = index;
            this.target = index;
            this.defaultValue = defaultValue;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void request(long n) {
            super.request(n);
            if (n > 0L) {
                this.s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            long i = this.index;
            if (i == 0L) {
                this.done = true;
                this.s.cancel();
                this.actual.onNext(t);
                this.actual.onComplete();
                return;
            }
            this.index = i - 1L;
            Operators.onDiscard(t, this.actual.currentContext());
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.defaultValue != null) {
                this.complete(this.defaultValue);
            } else {
                long count = this.target - this.index;
                this.actual.onError(Operators.onOperatorError(new IndexOutOfBoundsException("source had " + count + " elements, expected at least " + (this.target + 1L)), this.actual.currentContext()));
            }
        }
    }
}

