/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Exceptions;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.core.publisher.SourceProducer;
import java.time.Duration;
import java.util.Objects;

final class MonoError<T>
extends Mono<T>
implements Fuseable.ScalarCallable,
SourceProducer<T> {
    final Throwable error;

    MonoError(Throwable error) {
        this.error = Objects.requireNonNull(error, "error");
    }

    @Override
    public T block(Duration m) {
        throw Exceptions.propagate(this.error);
    }

    @Override
    public T block() {
        throw Exceptions.propagate(this.error);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.error(actual, this.error);
    }

    @Override
    public Object call() throws Exception {
        if (this.error instanceof Exception) {
            throw (Exception)this.error;
        }
        throw Exceptions.propagate(this.error);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

