/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Exceptions;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.core.publisher.SourceProducer;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

final class MonoErrorSupplied<T>
extends Mono<T>
implements Fuseable.ScalarCallable,
SourceProducer<T> {
    final Supplier<? extends Throwable> errorSupplier;

    MonoErrorSupplied(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = Objects.requireNonNull(errorSupplier, "errorSupplier");
    }

    @Override
    public T block(Duration m) {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        throw Exceptions.propagate(error);
    }

    @Override
    public T block() {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        throw Exceptions.propagate(error);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        Operators.error(actual, error);
    }

    @Override
    public Object call() throws Exception {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw Exceptions.propagate(error);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

