/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Subscription;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InnerOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.MonoFromFluxOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;

final class MonoIgnoreElements<T>
extends MonoFromFluxOperator<T, T> {
    MonoIgnoreElements(Flux<? extends T> source) {
        super(source);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new IgnoreElementsSubscriber<T>(actual);
    }

    static final class IgnoreElementsSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        Subscription s;

        IgnoreElementsSubscriber(CoreSubscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            Operators.onDiscard(t, this.actual.currentContext());
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }
    }
}

