/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxHide;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalMonoOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.BiFunction;

final class MonoLiftFuseable<I, O>
extends InternalMonoOperator<I, O>
implements Fuseable {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

    MonoLiftFuseable(Publisher<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        super(Mono.from(p));
        this.lifter = lifter;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return super.stepName();
    }

    @Override
    public CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super I> input = this.lifter.apply(this.source, actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        if (actual instanceof Fuseable.QueueSubscription && !(input instanceof Fuseable.QueueSubscription)) {
            input = new FluxHide.SuppressFuseableSubscriber<I>(input);
        }
        return input;
    }
}

