/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxMap;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalMonoOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.Function;

final class MonoMap<T, R>
extends InternalMonoOperator<T, R> {
    final Function<? super T, ? extends R> mapper;

    MonoMap(Mono<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            return new FluxMap.MapConditionalSubscriber<T, R>(cs, this.mapper);
        }
        return new FluxMap.MapSubscriber<T, R>(actual, this.mapper);
    }
}

