/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Subscription;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxMetrics;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InnerOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.InternalMonoOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;

final class MonoMetrics<T>
extends InternalMonoOperator<T, T> {
    final String name;
    final Tags tags;
    final MeterRegistry meterRegistry;

    MonoMetrics(Mono<? extends T> mono) {
        this(mono, null);
    }

    MonoMetrics(Mono<? extends T> mono, @Nullable MeterRegistry meterRegistry) {
        super(mono);
        this.name = FluxMetrics.resolveName(mono);
        this.tags = FluxMetrics.resolveTags(mono, FluxMetrics.DEFAULT_TAGS_MONO, this.name);
        this.meterRegistry = meterRegistry == null ? Metrics.globalRegistry : meterRegistry;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MetricsSubscriber<T>(actual, this.meterRegistry, Clock.SYSTEM, this.tags);
    }

    static class MetricsSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Clock clock;
        final Tags commonTags;
        final MeterRegistry registry;
        Timer.Sample subscribeToTerminateSample;
        boolean done;
        Subscription s;

        MetricsSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, Tags commonTags) {
            this.actual = actual;
            this.clock = clock;
            this.commonTags = commonTags;
            this.registry = registry;
        }

        @Override
        public final CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public final void cancel() {
            FluxMetrics.recordCancel(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.s.cancel();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.actual.onComplete();
        }

        @Override
        public final void onError(Throwable e) {
            if (this.done) {
                FluxMetrics.recordMalformed(this.commonTags, this.registry);
                Operators.onErrorDropped(e, this.actual.currentContext());
                return;
            }
            this.done = true;
            FluxMetrics.recordOnError(this.commonTags, this.registry, this.subscribeToTerminateSample, e);
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                FluxMetrics.recordMalformed(this.commonTags, this.registry);
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.actual.onNext(t);
            this.actual.onComplete();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                FluxMetrics.recordOnSubscribe(this.commonTags, this.registry);
                this.subscribeToTerminateSample = Timer.start((Clock)this.clock);
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public final void request(long l) {
            if (Operators.validate(l)) {
                this.s.request(l);
            }
        }
    }
}

