/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxFromMonoOperator;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxRepeat;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;

final class MonoRepeat<T>
extends FluxFromMonoOperator<T, T> {
    final long times;

    MonoRepeat(Mono<? extends T> source, long times) {
        super(source);
        if (times <= 0L) {
            throw new IllegalArgumentException("times > 0 required");
        }
        this.times = times;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        FluxRepeat.RepeatSubscriber<T> parent = new FluxRepeat.RepeatSubscriber<T>(this.source, actual, this.times + 1L);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
        return null;
    }
}

