/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactor.core.CorePublisher;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.core.publisher.OptimizableOperator;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import java.util.Objects;

final class MonoSourceFuseable<I>
extends Mono<I>
implements Fuseable,
Scannable,
OptimizableOperator<I, I> {
    final Publisher<? extends I> source;
    @Nullable
    final OptimizableOperator<?, I> optimizableOperator;

    MonoSourceFuseable(Publisher<? extends I> source) {
        OptimizableOperator optimSource;
        this.source = Objects.requireNonNull(source);
        this.optimizableOperator = source instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)source) : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super I> actual) {
        this.source.subscribe(actual);
    }

    @Override
    public final CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super I> actual) {
        return actual;
    }

    @Override
    public final CorePublisher<? extends I> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends I> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }
}

