/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxSubscribeOnValue;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.core.publisher.OperatorDisposables;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Operators;
import de.themoep.connectorplugin.lib.reactor.core.scheduler.Scheduler;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

final class MonoSubscribeOnValue<T>
extends Mono<T>
implements Scannable {
    final T value;
    final Scheduler scheduler;

    MonoSubscribeOnValue(@Nullable T value, Scheduler scheduler) {
        this.value = value;
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        T v = this.value;
        if (v == null) {
            FluxSubscribeOnValue.ScheduledEmpty parent = new FluxSubscribeOnValue.ScheduledEmpty(actual);
            actual.onSubscribe(parent);
            try {
                parent.setFuture(this.scheduler.schedule(parent));
            }
            catch (RejectedExecutionException ree) {
                if (parent.future != OperatorDisposables.DISPOSED) {
                    actual.onError(Operators.onRejectedExecution(ree, actual.currentContext()));
                }
            }
        } else {
            actual.onSubscribe(new FluxSubscribeOnValue.ScheduledScalar<T>(actual, v, this.scheduler));
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.scheduler;
        }
        return null;
    }
}

