/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactor.core.publisher.RingBuffer;
import de.themoep.connectorplugin.lib.reactor.core.publisher.RingBufferProducer;
import de.themoep.connectorplugin.lib.reactor.core.publisher.UnsafeSequence;
import de.themoep.connectorplugin.lib.reactor.util.concurrent.WaitStrategy;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

final class MultiProducerRingBuffer
extends RingBufferProducer {
    private static final Unsafe UNSAFE = (Unsafe)RingBuffer.getUnsafe();
    private static final long BASE = UNSAFE.arrayBaseOffset(int[].class);
    private static final long SCALE = UNSAFE.arrayIndexScale(int[].class);
    private final RingBuffer.Sequence gatingSequenceCache = new UnsafeSequence(-1L);
    private final int[] availableBuffer;
    private final int indexMask;
    private final int indexShift;

    MultiProducerRingBuffer(int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        super(bufferSize, waitStrategy, spinObserver);
        this.availableBuffer = new int[bufferSize];
        this.indexMask = bufferSize - 1;
        this.indexShift = RingBuffer.log2(bufferSize);
        this.initialiseAvailableBuffer();
    }

    @Override
    long next() {
        return this.next(1);
    }

    @Override
    long next(int n) {
        long next;
        while (true) {
            long cachedGatingSequence;
            long current;
            long wrapPoint;
            if ((wrapPoint = (next = (current = this.cursor.getAsLong()) + (long)n) - (long)this.bufferSize) > (cachedGatingSequence = this.gatingSequenceCache.getAsLong()) || cachedGatingSequence > current) {
                long gatingSequence = RingBuffer.getMinimumSequence(this.gatingSequences, current);
                if (wrapPoint > gatingSequence) {
                    if (this.spinObserver != null) {
                        this.spinObserver.run();
                    }
                    LockSupport.parkNanos(1L);
                    continue;
                }
                this.gatingSequenceCache.set(gatingSequence);
                continue;
            }
            if (this.cursor.compareAndSet(current, next)) break;
        }
        return next;
    }

    @Override
    long getPending() {
        long consumed = RingBuffer.getMinimumSequence(this.gatingSequences, this.cursor.getAsLong());
        long produced = this.cursor.getAsLong();
        return produced - consumed;
    }

    private void initialiseAvailableBuffer() {
        for (int i = this.availableBuffer.length - 1; i != 0; --i) {
            this.setAvailableBufferValue(i, -1);
        }
        this.setAvailableBufferValue(0, -1);
    }

    @Override
    void publish(long sequence) {
        this.setAvailable(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    private void setAvailable(long sequence) {
        this.setAvailableBufferValue(this.calculateIndex(sequence), this.calculateAvailabilityFlag(sequence));
    }

    private void setAvailableBufferValue(int index, int flag) {
        long bufferAddress = (long)index * SCALE + BASE;
        UNSAFE.putOrderedInt(this.availableBuffer, bufferAddress, flag);
    }

    boolean isAvailable(long sequence) {
        int index = this.calculateIndex(sequence);
        int flag = this.calculateAvailabilityFlag(sequence);
        long bufferAddress = (long)index * SCALE + BASE;
        return UNSAFE.getIntVolatile(this.availableBuffer, bufferAddress) == flag;
    }

    @Override
    long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        for (long sequence = lowerBound; sequence <= availableSequence; ++sequence) {
            if (this.isAvailable(sequence)) continue;
            return sequence - 1L;
        }
        return availableSequence;
    }

    private int calculateAvailabilityFlag(long sequence) {
        return (int)(sequence >>> this.indexShift);
    }

    private int calculateIndex(long sequence) {
        return (int)sequence & this.indexMask;
    }
}

