/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.reactor.core.publisher;

import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactor.core.CoreSubscriber;
import de.themoep.connectorplugin.lib.reactor.core.Fuseable;
import de.themoep.connectorplugin.lib.reactor.core.Scannable;
import de.themoep.connectorplugin.lib.reactor.core.publisher.AssemblyOp;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxOnAssembly;
import de.themoep.connectorplugin.lib.reactor.core.publisher.ParallelFlux;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;

final class ParallelFluxOnAssembly<T>
extends ParallelFlux<T>
implements Fuseable,
AssemblyOp,
Scannable {
    final ParallelFlux<T> source;
    final FluxOnAssembly.AssemblySnapshot stacktrace;

    ParallelFluxOnAssembly(ParallelFlux<T> source, FluxOnAssembly.AssemblySnapshot stacktrace) {
        this.source = source;
        this.stacktrace = stacktrace;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        CoreSubscriber[] parents = new CoreSubscriber[n];
        for (int i = 0; i < n; ++i) {
            CoreSubscriber<? super T> s = subscribers[i];
            if (s instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
                s = new FluxOnAssembly.OnAssemblyConditionalSubscriber<T>(cs, this.stacktrace, (Publisher<?>)this.source);
            } else {
                s = new FluxOnAssembly.OnAssemblySubscriber<T>(s, this.stacktrace, this.source);
            }
            parents[i] = s;
        }
        this.source.subscribe(parents);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.ACTUAL_METADATA) {
            return !this.stacktrace.checkpointed;
        }
        return null;
    }

    @Override
    public String stepName() {
        return this.stacktrace.operatorAssemblyInformation();
    }

    @Override
    public String toString() {
        return this.stacktrace.operatorAssemblyInformation();
    }
}

