/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.brigadier.tree.CommandNode;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.InvocableCommand;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import de.themoep.connectorplugin.BridgeCommon;
import de.themoep.connectorplugin.BridgedCommand;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ResponseHandler;
import de.themoep.connectorplugin.connector.ConnectingPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.velocity.VelocityConnectorPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;

public class Bridge
extends BridgeCommon<VelocityConnectorPlugin> {
    private Table<String, String, BridgedCommand<?, CommandSource>> commands = HashBasedTable.create();

    public Bridge(VelocityConnectorPlugin plugin) {
        super(plugin);
        plugin.getConnector().registerHandler(plugin, "started", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            for (BridgedCommand command : this.commands.values()) {
                this.registerServerCommand(senderServer, command);
            }
        });
        plugin.getConnector().registerHandler(plugin, "send_to_server", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetServer = in.readUTF();
            Player player = plugin.getProxy().getPlayer(playerName).orElse(null);
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + " on this proxy to send to server " + targetServer, new Throwable[0]);
                this.sendResponse(senderServer, id, false, "Could not find player " + playerName + " on this proxy to send to server " + targetServer);
                return;
            }
            RegisteredServer server = plugin.getProxy().getServer(targetServer).orElse(null);
            if (server == null) {
                plugin.logDebug("Could not find server " + targetServer + " on this proxy to send player " + playerName + " to", new Throwable[0]);
                this.sendResponse(senderServer, id, false, "Could not find server " + targetServer + " on this proxy to send player " + playerName + " to");
                return;
            }
            if (!player.getCurrentServer().isPresent() || !((ServerConnection)player.getCurrentServer().get()).getServer().equals(server)) {
                plugin.logDebug("Sending '" + playerName + "' to server '" + targetServer + "'. Triggered from " + senderServer, new Throwable[0]);
                player.createConnectionRequest(server).connect().thenAccept(result -> {
                    this.sendResponse(senderServer, id, result.isSuccessful(), new String[0]);
                    result.getReasonComponent().ifPresent(c -> this.sendResponseMessage(senderServer, id, LegacyComponentSerializer.legacyAmpersand().serialize(c)));
                });
            } else {
                plugin.logDebug("Player '" + playerName + "' is already on server '" + targetServer + "'! Triggered from " + senderServer, new Throwable[0]);
                this.sendResponse(senderServer, id, true, playerName + " is already connected to server " + targetServer);
            }
        });
        plugin.getConnector().registerHandler(plugin, "teleport", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            LocationInfo targetLocation = LocationInfo.read(in);
            this.teleport(playerName, targetLocation, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "teleport_to_world", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetServer = in.readUTF();
            String targetWorld = in.readUTF();
            this.teleport(playerName, targetServer, targetWorld, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "teleport_to_player", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetName = in.readUTF();
            this.teleport(playerName, targetName, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "player_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            UUID playerId = new UUID(in.readLong(), in.readLong());
            String command = in.readUTF();
            Player player = plugin.getProxy().getPlayer(playerId).orElseGet(() -> plugin.getProxy().getPlayer(playerName).orElse(null));
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + "/" + playerId + " on this proxy to execute command " + command, new Throwable[0]);
                this.sendResponse(serverName, id, false, "Could not find player " + playerName + "/" + playerId + " on this proxy to execute command " + command);
                return;
            }
            plugin.logDebug("Command '" + command + "' for player '" + playerName + "' triggered from " + serverName, new Throwable[0]);
            Player finalPlayer = player;
            plugin.getProxy().getCommandManager().executeAsync((CommandSource)finalPlayer, command).thenAccept(success -> this.sendResponse(serverName, id, finalPlayer, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "console_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String command = in.readUTF();
            plugin.logDebug("Console command '" + command + "' triggered from " + senderServer, new Throwable[0]);
            plugin.getProxy().getCommandManager().executeAsync((CommandSource)new BridgedSender(senderServer, id), command).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "execute_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            String senderName = in.readUTF();
            String pluginName = in.readUTF();
            String commandName = in.readUTF();
            Object sender = senderName.isEmpty() ? plugin.getProxy().getConsoleCommandSource() : (CommandSource)plugin.getProxy().getPlayer(senderName).orElse(null);
            if (sender == null) {
                plugin.logDebug("Could not find player " + senderName + " for execution of command " + commandName + " for plugin " + pluginName, new Throwable[0]);
                return;
            }
            BridgedCommand command = (BridgedCommand)this.commands.get((Object)pluginName.toLowerCase(Locale.ROOT), (Object)commandName.toLowerCase(Locale.ROOT));
            if (command == null) {
                plugin.logDebug("Could not find executor for command " + commandName + " for plugin " + pluginName, new Throwable[0]);
                return;
            }
            String commandLabel = in.readUTF();
            int argsCount = in.readInt();
            String[] args = new String[argsCount];
            for (int i = 0; i < argsCount; ++i) {
                args[i] = in.readUTF();
            }
            LocationInfo location = null;
            if (sender instanceof Player) {
                location = LocationInfo.read(in);
            }
            try {
                if (!command.onCommand(sender, location, commandLabel, args) && command.getUsage().length() > 0) {
                    for (String line : command.getUsage().replace("<command>", commandLabel).split("\n")) {
                        sender.sendMessage((Component)Component.text((String)line));
                    }
                }
            }
            catch (Throwable ex) {
                plugin.logError("Unhandled exception executing bridged command '" + commandLabel + "' from plugin " + command.getPlugin().getName(), ex);
            }
        });
        plugin.getConnector().registerHandler(plugin, "response", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            long id = in.readLong();
            boolean isCompletion = in.readBoolean();
            if (isCompletion) {
                this.handleResponse(id, in);
            } else {
                String message = in.readUTF();
                Consumer[] consumer = (Consumer[])this.consumers.getIfPresent((Object)id);
                if (consumer != null) {
                    for (Consumer stringConsumer : consumer) {
                        stringConsumer.accept(message);
                    }
                }
            }
        });
    }

    private void sendResponse(String server, long id, Player player, boolean success, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(true);
        out.writeBoolean(success);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "response", MessageTarget.SERVER, player, out.toByteArray());
        if (messages.length > 0) {
            this.sendResponseMessage(server, id, messages);
        }
    }

    private void sendResponse(String server, long id, boolean success, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(true);
        out.writeBoolean(success);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "response", server.startsWith("proxy:") ? MessageTarget.OTHER_PROXIES : MessageTarget.ALL_QUEUE, out.toByteArray());
        if (messages.length > 0) {
            this.sendResponseMessage(server, id, messages);
        }
    }

    private void sendResponseMessage(String server, long id, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(false);
        out.writeUTF(String.join((CharSequence)"\n", messages));
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "response", server.startsWith("proxy:") ? MessageTarget.OTHER_PROXIES : MessageTarget.ALL_QUEUE, out.toByteArray());
    }

    public CompletableFuture<Boolean> teleport(String playerName, LocationInfo location, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Player player = ((VelocityConnectorPlugin)this.plugin).getProxy().getPlayer(playerName).orElse(null);
        if (player == null) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + location, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + location);
            }
            return future;
        }
        RegisteredServer server = ((VelocityConnectorPlugin)this.plugin).getProxy().getServer(location.getServer()).orElse(null);
        if (server == null) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Could not find server " + location.getServer() + " on this proxy to teleport player " + player.getUsername() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find server " + location.getServer() + " on this proxy to teleport player " + player.getUsername() + " to");
            }
            return future;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getUsername());
        location.write(out);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "teleport", MessageTarget.SERVER, server.getServerInfo().getName(), out.toByteArray());
        this.sendToServerIfNecessary(player, server, future, consumer);
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, String serverName, String worldName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Player player = ((VelocityConnectorPlugin)this.plugin).getProxy().getPlayer(playerName).orElse(null);
        if (player == null) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + serverName + "/" + worldName, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + serverName + "/" + worldName);
            }
            return future;
        }
        RegisteredServer server = ((VelocityConnectorPlugin)this.plugin).getProxy().getServer(serverName).orElse(null);
        if (server == null) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Could not find server " + serverName + " on this proxy to teleport player " + player.getUsername() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find server " + serverName + " on this proxy to teleport player " + player.getUsername() + " to");
            }
            return future;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getUsername());
        out.writeUTF(serverName);
        out.writeUTF(worldName);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "teleport_to_world", MessageTarget.SERVER, server.getServerInfo().getName(), out.toByteArray());
        this.sendToServerIfNecessary(player, server, future, consumer);
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, String targetName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Player player = ((VelocityConnectorPlugin)this.plugin).getProxy().getPlayer(playerName).orElse(null);
        if (player == null) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + targetName, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + targetName);
            }
            return future;
        }
        Player target = ((VelocityConnectorPlugin)this.plugin).getProxy().getPlayer(targetName).orElse(null);
        if (target == null) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Could not find target player " + targetName + " on this proxy to teleport " + player.getUsername() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find target player " + targetName + " on this proxy to teleport " + player.getUsername() + " to");
            }
            return future;
        }
        if (!target.getCurrentServer().isPresent()) {
            ((VelocityConnectorPlugin)this.plugin).logDebug(target.getUsername() + " is not currently connected to any server.", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept(target.getUsername() + " is not currently connected to any server.");
            }
            return future;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getUsername());
        out.writeUTF(target.getUsername());
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "teleport_to_player", MessageTarget.ALL_QUEUE, out.toByteArray());
        this.sendToServerIfNecessary(player, ((ServerConnection)target.getCurrentServer().get()).getServer(), future, consumer);
        return future;
    }

    private void sendToServerIfNecessary(Player player, RegisteredServer server, CompletableFuture<Boolean> future, Consumer<String> ... consumer) {
        if ((!player.getCurrentServer().isPresent() || !((ServerConnection)player.getCurrentServer().get()).getServer().equals(server)) && ((VelocityConnectorPlugin)this.plugin).getConnector().requiresPlayer() && server.getPlayersConnected().isEmpty()) {
            ((VelocityConnectorPlugin)this.plugin).logDebug("Sending '" + player.getUsername() + "' to server '" + server.getServerInfo().getName() + "'", new Throwable[0]);
            player.createConnectionRequest(server).connect().thenAccept(result -> {
                if (!result.isSuccessful()) {
                    future.complete(false);
                    result.getReasonComponent().ifPresent(component -> {
                        String reason = LegacyComponentSerializer.legacyAmpersand().serialize(component);
                        for (Consumer c : consumer) {
                            c.accept(reason);
                        }
                    });
                }
            });
        }
    }

    public CompletableFuture<LocationInfo> getLocation(Player player) {
        CompletableFuture<LocationInfo> future = new CompletableFuture<LocationInfo>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getUsername());
        this.responses.put((Object)id, (Object)new ResponseHandler.Location(future));
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "get_location", MessageTarget.SERVER, player, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runServerPlayerCommand(Player player, String command) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getUsername());
        out.writeLong(player.getUniqueId().getMostSignificantBits());
        out.writeLong(player.getUniqueId().getLeastSignificantBits());
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "player_command", MessageTarget.SERVER, player, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runServerConsoleCommand(String server, String command, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeUTF(server);
        out.writeLong(id);
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        if (consumer != null && consumer.length > 0) {
            this.consumers.put((Object)id, consumer);
        }
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "console_command", MessageTarget.ALL_QUEUE, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runProxyConsoleCommand(String command, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        if (consumer != null && consumer.length > 0) {
            this.consumers.put((Object)id, consumer);
        }
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "console_command", MessageTarget.OTHER_PROXIES, out.toByteArray());
        return future;
    }

    public void registerServerCommand(String server, BridgedCommand<?, CommandSource> command) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        this.write(out, command);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "register_command", MessageTarget.SERVER, server, out.toByteArray());
    }

    public void registerServerCommand(BridgedCommand<?, CommandSource> command) {
        this.commands.put((Object)command.getPlugin().getName().toLowerCase(Locale.ROOT), (Object)command.getName().toLowerCase(Locale.ROOT), command);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getServerName());
        this.write(out, command);
        ((VelocityConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "register_command", MessageTarget.ALL_QUEUE, out.toByteArray());
        ForwardingCommand mainCommand = new ForwardingCommand(command);
        ((VelocityConnectorPlugin)this.plugin).getProxy().getCommandManager().register((CommandMeta)mainCommand, (Command)mainCommand);
    }

    private void write(ByteArrayDataOutput out, BridgedCommand<?, CommandSource> command) {
        out.writeUTF(command.getPlugin().getName());
        out.writeUTF(command.getName());
        out.writeUTF(command.getDescription() != null ? command.getDescription() : "");
        out.writeUTF(command.getUsage() != null ? command.getUsage() : "");
        out.writeUTF(command.getPermission() != null ? command.getPermission() : "");
        if (command.getPermissionMessage() != null) {
            out.writeBoolean(true);
            out.writeUTF(command.getPermissionMessage());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(command.getAliases().length);
        for (String alias : command.getAliases()) {
            out.writeUTF(alias);
        }
    }

    private class ForwardingCommand
    implements SimpleCommand,
    CommandMeta {
        private final BridgedCommand<?, CommandSource> command;

        public ForwardingCommand(BridgedCommand<?, CommandSource> command) {
            this.command = command;
        }

        public void execute(SimpleCommand.Invocation invocation) {
            if (invocation.source() instanceof Player) {
                ((Player)invocation.source()).spoofChatInput("/" + invocation.alias() + " " + String.join((CharSequence)" ", (CharSequence[])invocation.arguments()));
            } else {
                this.command.onCommand(invocation.source(), null, invocation.alias(), (String[])invocation.arguments());
            }
        }

        public List<String> suggest(SimpleCommand.Invocation invocation) {
            if (this.command instanceof InvocableCommand && invocation.source().hasPermission(this.command.getPermission() + ".tabcomplete." + invocation.alias())) {
                return ((InvocableCommand)this.command).suggest((CommandInvocation)invocation);
            }
            return Collections.emptyList();
        }

        public Collection<CommandNode<CommandSource>> getHints() {
            if (this.command instanceof CommandMeta) {
                return ((CommandMeta)this.command).getHints();
            }
            return Collections.emptySet();
        }

        public Collection<String> getAliases() {
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add(this.command.getName());
            Collections.addAll(aliases, this.command.getAliases());
            return aliases;
        }
    }

    private class BridgedSender
    implements CommandSource {
        private final String serverName;
        private final long id;

        public BridgedSender(String serverName, long id) {
            this.serverName = serverName;
            this.id = id;
        }

        public Tristate getPermissionValue(String permission) {
            return Tristate.TRUE;
        }

        public void sendMessage(@NotNull ComponentLike message) {
            super.sendMessage(message);
        }

        public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type) {
            Bridge.this.sendResponseMessage(this.serverName, this.id, new String[]{LegacyComponentSerializer.legacySection().serialize(message)});
        }

        public void sendActionBar(@NotNull Component message) {
            Bridge.this.sendResponseMessage(this.serverName, this.id, new String[]{LegacyComponentSerializer.legacySection().serialize(message)});
        }

        public void showTitle(@NotNull Title title) {
            Bridge.this.sendResponseMessage(this.serverName, this.id, new String[]{LegacyComponentSerializer.legacySection().serialize(title.title()) + "\n" + LegacyComponentSerializer.legacySection().serialize(title.subtitle())});
        }
    }
}

